/*
 * libc.c 
 */

#include <libc.h>
#include <errno.h>
#include <utils.h>

int errno;
char *errno_vector[129];

/* Wrapper of  write system call*/
int write(int fd,char *buffer,int size)
{
	int r;
	__asm__ ("\
		movl %1, %%ebx; \
		movl %2, %%ecx; \
		movl %3, %%edx; \
		movl $4, %%eax; \
		int $0x80; \
		movl %%eax, %0; "
		: "=g" (r) 
		:"g" (fd), "g" (buffer),"g" (size)
		: "ebx"
	);
	if (r<0){
		errno = -r;
		return -1;
	}
	else return r;
}

int read(int fd,char *buffer,int size)
{
	int r;
	__asm__ ("\
		movl %1, %%ebx; \
		movl %2, %%ecx; \
		movl %3, %%edx; \
		movl $3, %%eax; \
		int $0x80; \
		movl %%eax, %0; "
		: "=g" (r) 
		:"g" (fd), "g" (buffer),"g" (size)
		: "ebx"
	);
	if (r<0){
		errno = -r;
		return -1;
	}
	else return r;
}

int getpid() {

	int r;
	__asm__ __volatile__ ("\
		movl $20, %%eax; \
		int $0x80; \
		movl %%eax, %0; "
		: "=g" (r)
	);
	return r;
}

int get_stats(int pid, int *tics) {
	int r;
	__asm__ __volatile__ ("\
		movl %1, %%ebx;	\
		movl %2, %%ecx;	\
		movl $35, %%eax; \
		int $0x80; \
		movl %%eax, %0; "
		: "=g" (r) : "g"(pid), "g"(tics)
		: "ebx"
	);
	if (r<0){
		errno = -r;
		return -1;
	}
	else return r;
}

int nice(int quantum) {

	int r;
	__asm__ __volatile__ ("\
		movl %1, %%ebx; \
		movl $34, %%eax; \
		int $0x80; \
		movl %%eax, %0; "
		: "=g" (r)
		: "g"(quantum)
		: "ebx"
	);
	if (r<0){
		errno = -r;
		return -1;
	} 
	return r;
}

int fork(){
	int r;
	__asm__ __volatile__ ("\
		movl $2, %%eax; \
		int $0x80; \
		movl %%eax, %0; "
		: "=g" (r)
	);
	if (r<0){
		errno = -r;
		return -1;
	} 
	return r;
}

void exit(){
	__asm__ __volatile__ ("\
		movl $1, %eax; \
		int $0x80; "
	);
}

void perror(){
	char buff[16];
	write(2, "Error ", 6);
	itoa (errno, buff);
	write(2, buff, strlen(buff));
	write(2, ": ", 2);
	write(2, errno_vector[errno], strlen(errno_vector[errno]));
	write(2, "\n", 1);
}

void init_errnoCodes(){
	errno_vector[EPERM] = " Operation not permitted ";
	errno_vector[ENOENT] = " No such file or directory ";
	errno_vector[ESRCH] = " No such process ";
	errno_vector[EINTR] = " Interrupted system call ";
	errno_vector[EIO] = " I/O error ";
	errno_vector[ENXIO] = " No such device or address ";
	errno_vector[E2BIG] = " Argument list too long ";
	errno_vector[ENOEXEC] = " Exec format error ";
	errno_vector[EBADF] = " Bad file number ";
	errno_vector[ECHILD] = " No child processes ";
	errno_vector[EAGAIN] = " Try again ";
	errno_vector[ENOMEM] = " Out of memory ";
	errno_vector[EACCES] = " Permission denied ";
	errno_vector[EFAULT] = " Bad address ";
	errno_vector[ENOTBLK] = " Block device required ";
	errno_vector[EBUSY] = " Device or resource busy ";
	errno_vector[EEXIST] = " File exists ";
	errno_vector[EXDEV] = " Cross-device link ";
	errno_vector[ENODEV] = " No such device ";
	errno_vector[ENOTDIR] = " Not a directory ";
	errno_vector[EISDIR] = " Is a directory ";
	errno_vector[EINVAL] = " Invalid argument ";
	errno_vector[ENFILE] = " File table overflow ";
	errno_vector[EMFILE] = " Too many open files ";
	errno_vector[ENOTTY] = " Not a typewriter ";
	errno_vector[ETXTBSY] = " Text file busy ";
	errno_vector[EFBIG] = " File too large ";
	errno_vector[ENOSPC] = " No space left on device ";
	errno_vector[ESPIPE] = " Illegal seek ";
	errno_vector[EROFS] = " Read-only file system ";
	errno_vector[EMLINK] = " Too many links ";
	errno_vector[EPIPE] = " Broken pipe ";
	errno_vector[EDOM] = " Math argument out of domain of func ";
	errno_vector[ERANGE] = " Math result not representable ";
	errno_vector[EDEADLK] = " Resource deadlock would occur ";
	errno_vector[ENAMETOOLONG] = " File name too long ";
	errno_vector[ENOLCK] = " No record locks available ";
	errno_vector[ENOSYS] = " Function not implemented ";
	errno_vector[ENOTEMPTY] = " Directory not empty ";
	errno_vector[ELOOP] = " Too many symbolic links encountered ";
	//errno_vector[EWOULDBLOCK] = " Operation would block ";
	errno_vector[ENOMSG] = " No message of desired type ";
	errno_vector[EIDRM] = " Identifier removed ";
	errno_vector[ECHRNG] = " Channel number out of range ";
	errno_vector[EL2NSYNC] = " Level 2 not synchronized ";
	errno_vector[EL3HLT] = " Level 3 halted ";
	errno_vector[EL3RST] = " Level 3 reset ";
	errno_vector[ELNRNG] = " Link number out of range ";
	errno_vector[EUNATCH] = " Protocol driver not attached ";
	errno_vector[ENOCSI] = " No CSI structure available ";
	errno_vector[EL2HLT] = " Level 2 halted ";
	errno_vector[EBADE] = " Invalid exchange ";
	errno_vector[EBADR] = " Invalid request descriptor ";
	errno_vector[EXFULL] = " Exchange full ";
	errno_vector[ENOANO] = " No anode ";
	errno_vector[EBADRQC] = " Invalid request code ";
	errno_vector[EBADSLT] = " Invalid slot ";
	errno_vector[EBFONT] = " Bad font file format ";
	errno_vector[ENOSTR] = " Device not a stream ";
	errno_vector[ENODATA] = " No data available ";
	errno_vector[ETIME] = " Timer expired ";
	errno_vector[ENOSR] = " Out of streams resources ";
	errno_vector[ENONET] = " Machine is not on the network ";
	errno_vector[ENOPKG] = " Package not installed ";
	errno_vector[EREMOTE] = " Object is remote ";
	errno_vector[ENOLINK] = " Link has been severed ";
	errno_vector[EADV] = " Advertise error ";
	errno_vector[ESRMNT] = " Srmount error ";
	errno_vector[ECOMM] = " Communication error on send ";
	errno_vector[EPROTO] = " Protocol error ";
	errno_vector[EMULTIHOP] = " Multihop attempted ";
	errno_vector[EDOTDOT] = " RFS specific error ";
	errno_vector[EBADMSG] = " Not a data message ";
	errno_vector[EOVERFLOW] = " Value too large for defined data type ";
	errno_vector[ENOTUNIQ] = " Name not unique on network ";
	errno_vector[EBADFD] = " File descriptor in bad state ";
	errno_vector[EREMCHG] = " Remote address changed ";
	errno_vector[ELIBACC] = " Can not access a needed shared library ";
	errno_vector[ELIBBAD] = " Accessing a corrupted shared library ";
	errno_vector[ELIBSCN] = " .lib section in a.out corrupted ";
	errno_vector[ELIBMAX] = " Attempting to link in too many shared libraries ";
	errno_vector[ELIBEXEC] = " Cannot exec a shared library directly ";
	errno_vector[EILSEQ] = " Illegal byte sequence ";
	errno_vector[ERESTART] = " Interrupted system call should be restarted ";
	errno_vector[ESTRPIPE] = " Streams pipe error ";
	errno_vector[EUSERS] = " Too many users ";
	errno_vector[ENOTSOCK] = " Socket operation on non-socket ";
	errno_vector[EDESTADDRREQ] = " Destination address required ";
	errno_vector[EMSGSIZE] = " Message too long ";
	errno_vector[EPROTOTYPE] = " Protocol wrong type for socket ";
	errno_vector[ENOPROTOOPT] = " Protocol not available ";
	errno_vector[EPROTONOSUPPORT] = " Protocol not supported ";
	errno_vector[ESOCKTNOSUPPORT] = " Socket type not supported ";
	errno_vector[EOPNOTSUPP] = " Operation not supported on transport endpoint ";
	errno_vector[EPFNOSUPPORT] = " Protocol family not supported ";
	errno_vector[EAFNOSUPPORT] = " Address family not supported by protocol ";
	errno_vector[EADDRINUSE] = " Address already in use ";
	errno_vector[EADDRNOTAVAIL] = " Cannot assign requested address ";
	errno_vector[ENETDOWN] = " Network is down ";
	errno_vector[ENETUNREACH] = " Network is unreachable ";
	errno_vector[ENETRESET] = " Network dropped connection because of reset ";
	errno_vector[ECONNABORTED] = " Software caused connection abort ";
	errno_vector[ECONNRESET] = " Connection reset by peer ";
	errno_vector[ENOBUFS] = " No buffer space available ";
	errno_vector[EISCONN] = " Transport endpoint is already connected ";
	errno_vector[ENOTCONN] = " Transport endpoint is not connected ";
	errno_vector[ESHUTDOWN] = " Cannot send after transport endpoint shutdown ";
	errno_vector[ETOOMANYREFS] = " Too many references: cannot splice ";
	errno_vector[ETIMEDOUT] = " Connection timed out ";
	errno_vector[ECONNREFUSED] = " Connection refused ";
	errno_vector[EHOSTDOWN] = " Host is down ";
	errno_vector[EHOSTUNREACH] = " No route to host ";
	errno_vector[EALREADY] = " Operation already in progress ";
	errno_vector[EINPROGRESS] = " Operation now in progress ";
	errno_vector[ESTALE] = " Stale NFS file handle ";
	errno_vector[EUCLEAN] = " Structure needs cleaning ";
	errno_vector[ENOTNAM] = " Not a XENIX named type file ";
	errno_vector[ENAVAIL] = " No XENIX semaphores available ";
	errno_vector[EISNAM] = " Is a named type file ";
	errno_vector[EREMOTEIO] = " Remote I/O error ";
	errno_vector[EDQUOT] = " Quota exceeded ";
	errno_vector[ENOMEDIUM] = " No medium found ";
	errno_vector[EMEDIUMTYPE] = " Wrong medium type ";
	errno_vector[ECANCELED] = " Operation Canceled ";
	errno_vector[ENOKEY] = " Required key not available ";
	errno_vector[EKEYEXPIRED] = " Key has expired ";
	errno_vector[EKEYREVOKED] = " Key has been revoked ";
	errno_vector[EKEYREJECTED] = " Key was rejected by service ";
}
