/*
 * list.c - Simple doubly linked list
 */

#include <list.h>
#define NULL (unsigned long)0x00000000

 int list_init(struct list *l)
{
	if(l==NULL) return -1;
	l->first=NULL;
	l->last=NULL;
	return 0;
}

int list_add(struct list_head *new, struct list *l)
{
	if(l==NULL) return -1;
	if(new==NULL) return -1;
	if(l->first==NULL) { 		// lista vacia
		new->prev=new;
		new->next=new;
		l->first=new;
		l->last=new;
	}
	else {
		new->next=l->first;
		new->prev=l->last;
		l->first->prev=new;
		l->last->next=new;
		l->last=new;
	}
	return 0;
}

int list_del(struct list_head *entry, struct list *l)
{
	// pre:si entry!=NULL, *entry se encuentra en *l

	if(entry==NULL) return -1;
	if(l==NULL) return -1;
	if(l->first==l->last) { //la lista tiene un elemento
		l->first=NULL;
		l->last=NULL;
		
	}
	else if(l->first==entry) { //se borra el primero de l
		l->first=entry->next;
		entry->next->prev=l->last;
		l->last->next=entry->next;
	}
	else if(l->last==entry) {	//se borra el ultimo
		entry->prev->next=l->first;
		l->first->prev=entry->prev;
		l->last=entry->prev;
	}
	else {  // se borra uno del medio
		entry->prev->next=entry->next;
		entry->next->prev=entry->prev;
	}
	entry->prev=NULL;
	entry->next=NULL;
	return 0;
}
struct list_head * list_first(struct list *l)
{
	if(l==NULL) return NULL;
	else return l->first;
}

struct list_head * list_next(struct list_head *entry)
{
	if(entry==NULL) return NULL;
	return entry->next;
}

int list_empty(struct list *l)
{
	if(l==NULL) return -1;
	if(l->first==NULL) return 1;
	return 0;
}

