

#include "round_buffer.h"

void inicializar(struct round_buffer *buf){
	buf->ini=0;
	buf->n=0;
}

void escribir (char c,struct round_buffer *buf){
	if (buf->n == SIZE_RB) return;	//BUFFER LLENO -----------> SE DESPRECIA EL CARACTER LEIDO
	int i = (buf->ini + buf->n) % SIZE_RB;
	buf->buff[i] = c;
	buf->n++;
}

char leer(struct round_buffer *buf){
	if (buf->n == 0) return -1;	// BUFFER VACIO
	char c = buf->buff[buf->ini];	//LEEMOS EL CARACTER
	buf->n--;		
	buf->ini++;
	if (buf->ini == SIZE_RB) buf->ini=0;	// SI EL PUNTERO DE INICIO LLEGA AL FINAL, VUELVE A LA POSICION 0
	return c;
}
