/*
 * sys.c - Syscalls implementation
 */
#include <types.h>
#include <sched.h>
#include <mm_address.h>
#include <mm.h>
#include <segment.h>
#include <segment.h>
#include <devices.h>
#include <errno.h>
#include <utils.h>
#include <constants.h>
#include <list.h>
#include <sched.h>
#include <fd.h>
#include <io.h>
#include <devices.h>

int sys_write(int fd,char *buffer, int size){
	if (size < 0) return -EFAULT;
	int r = comprova_fd(fd, ESCRITURA);
	if (r < 0) return r;

	int (*p_write)(char *pbuff, int psize) = current()->tc[fd].dd->write;

	char *act = buffer;
	int cont = 0;
	int size_act;
	int free_size = free_space()-256;
	while (cont<size) {
		if (free_size < size) size_act = free_size;
		else size_act = size;
		char kernel_buffer[size_act];	// DEJAMOS UN POCO DE MARGEN PARA SYS_WRITE_CONSOLE

		r = copy_from_user (act, kernel_buffer, size_act);
			if (r<0) return -EFAULT;
		r = p_write(kernel_buffer, size_act);
			if (r<0) return r;
			else cont += r;
		act += size_act;
	}
	return cont;
}

int sys_read(int fd,char *buffer,int size){
	if (size < 0) return -EFAULT;
	int r = comprova_fd(fd, LECTURA);
	if (r < 0) return r;

	int (*p_read)(char *pbuff, int psize) = current()->tc[fd].dd->read;

	char *act = buffer;
	int cont = 0;
	int size_act;
	int free_size = free_space()-256;
	while (cont<size) {
		if (free_size < size) size_act = free_size;
		else size_act = size;
		char kernel_buffer[size_act];	// DEJAMOS UN POCO DE MARGEN PARA SYS_READ_CONSOLE

		r = p_read(kernel_buffer, size_act);
			if (r<0) return r;
			else cont += r;
		r = copy_to_user (kernel_buffer, act, size_act);
			if (r<0) return -EFAULT;
		act += size_act;
	}
	return cont;
}

int sys_close(){}

int sys_dup(){}

int sys_sem_init(){}

int sys_sem_wait(){}

int sys_sem_signal(){}


int sys_ni_call(){
	return -ENOSYS;
}

int sys_getpid() {
	return	current()->pid;
}

int sys_nice(int quantum){
	if (quantum<=0) return -EPERM;
	int last_quantum = current()->quantum;
	current()->quantum = quantum;
	return last_quantum;
}

int asignar_paginas(struct task_struct *t){
	// ASIGNAR PAGINAS DE KERNEL
	int asignadas, i;
	asignadas = 0;
	i = 0;
	while (i < USER_PAGES && asignadas < NUM_PAG_DATA) {
		if (!user_pages_bitmap[i]){	// SI LA PAGINA ESTA LIBRE SE LA ASIGNAMOS
			set_ss_pag(PAG_LOG_INIT_DATA_P0 + NUM_PAG_DATA + asignadas, i + PAG_LOG_INIT_DATA_P0);	// CARGAMOS EN LA TABLA DE PAGINAS
			t->tp[asignadas] = i + PAG_LOG_INIT_DATA_P0;		// ACTUALIZAMOS TP DEL PROCESO
			user_pages_bitmap[i] = TRUE;				// ACTUALIZAMOS BITMAP
			asignadas++;
		}
		i++;
	}
	if (asignadas < NUM_PAG_DATA) return -1; // RETORNAR ERROR DE QU NO HAY SUFICIENTE MEMORIA USUARIO
	return 0;
}

int sys_fork(){
	// Buscamos una entrada libre el el task_bitmap
	int i = 0; 
	while (i< NR_TASKS && task_bitmap[i]!=FALSE) i++;
	if (i==NR_TASKS) return -EAGAIN; // DEVOLVER ERROR QUE NO SE PUEDE CREAR LA TAREA PQ NO HAY ESPACIO PARA MAS PROCESOS
	else task_bitmap[i] = TRUE;
	// COPIAMOS LA PILA DE KERNEL DEL PADRE AL HIJO
	// HEMOS DE COPIAR A PARTIR DE STACK PARA NO PERDER EL TASK_STRUCT DEL HIJO
	union task_union *act = (union task_union *)current();
	copy_data(act, &task[i], (KERNEL_STACK_SIZE*4)); 

	// Buscamos y asignamos paginas de datos+pila al nuevo proceso
	int error=asignar_paginas(&task[i].task);
	if(error<0) return -ENOMEM;

	// COPIAMOS LA PILA+DATOS DE USUARIO DEL PADRE AL HIJO
	void *start = (void *) (PAG_LOG_INIT_DATA_P0 << 12);
	void *dest = (void *) ((PAG_LOG_INIT_DATA_P0<<12) + (NUM_PAG_DATA*PAGE_SIZE));
	copy_data(start, dest, (PAGE_SIZE*NUM_PAG_DATA)); 
	
	// Quitamos las paginas del hijo de la tabla de paginas
	int k;
	for (k = 0; k < NUM_PAG_DATA; k++){
		del_ss_pag(PAG_LOG_INIT_DATA_P0 + NUM_PAG_DATA + k);		
	}
	set_cr3(); // FLUSH

	// Inicializamos el task struct del proceso nuevo
	task[i].task.pid = total_process;
	task[i].task.ppid = current()->pid;
	task[i].task.status = STATUS_READY;
	task[i].task.quantum = current()->quantum;
	task[i].task.cpu_time = 0;

	total_process ++ ;

	// Añadimos el proceso a la runqueue
	list_add(&task[i].task.lh, &runqueue);

	// Calculamos el esp del hijo
	// esp_hijo = esp_padre + (@taskstruct_hijo - @taskstruct_padre)
	struct task_struct *tsact = &act->task;
	DWord esp_hijo;
	DWord ebp_hijo;
	__asm__ __volatile__ ("\
			pushl %%eax;		\
			pushl %%ebx;		\
			movl %2, %%eax; 	\
			movl %3, %%ebx;		\
			subl %%ebx, %%eax;  	\
			movl %%eax, %%ebx;	\
			addl %%esp, %%ebx;	\
			addl $8, %%ebx;		\
			movl %%ebx, %0; 	\
			addl %%ebp, %%eax; 	\
			movl %%eax, %1; 	\
			popl %%ebx;		\
			popl %%eax;		\
		"
		: "=g"(esp_hijo), "=g"(ebp_hijo) : "g" (&task[i].task), "g"(tsact)
	);

	/* Iniciamos la emulacion del switch_pocess
	*  Movemos a esi la @de retorno del hijo.
	*  %0 -> pid
	*  %1 -> @esp del hijo
	*  %2 -> @task_struct->esp del hijo
	*  esi <- guardamos la @de retorno del hijo
	*  edi <- puntero a la cima del hijo = esp_padre + (@tsph - @tsp)
	*
	*	|               |
	*	|_______________|
	*	|     %ebx      |-28 <- esp del task struct
	*	|_______________|
	*	|     %edi      |-24
	*	|_______________|
	*	|     %esi      |-20
	*	|_______________|
	*	|     %ebp      |-16
	*	|_______________|
	*	|     @ret      |-12 # la direccion de retorno es la etiqueta "hijo"
	*	|_______________|
	*	|     param2    |-8
	*	|_______________|
	*	|     param1    |-4 
	*	|_______________|
	*	|     FORK      | <- edi
	*	|_______________|
	*/
	int pid = 0;
	__asm__ __volatile__("\
			pushl %%esi; 			\
			pushl %%edi; 			\
			pushl %%ebx; 			\
		lea hijo, %%esi; 		\
		movl %1, %%edi; 		\
		movl %%esi, -12(%%edi); 	\
		movl %4, -16(%%edi); 		\
		movl 8(%%esp), %%esi;		\
		movl %%esi, -20(%%edi);		\
		movl 4(%%esp), %%esi;		\
		movl %%esi, -24(%%edi);		\
		movl (%%esp), %%esi;		\
		movl %%esi, -28(%%edi);		\
		movl %2, %%esi;			\
		subl $28, %%edi;		\
		movl %%edi, (%%esi);		\
		movl %3, %0;			\
			popl %%ebx; 		\
			popl %%edi; 		\
			popl %%esi; 		\
		jmp comun;			\
		hijo: 				\
			addl $8, %%esp;		\
			movb $0x20, %%al; 	\
			outb %%al, $0x20;	\
			movl $0, %0; 		\
		comun:				\
		"
		: "=g"(pid) : "g"(esp_hijo), "g" (&task[i].task.esp), "g" (total_process-1), "g" (ebp_hijo)
	);
	return pid;
}

int sys_get_stats(int pid, int *tics){
	if (((DWord)(tics) < (PAG_LOG_INIT_DATA_P0<<12)) || ((DWord)(tics) > ((PAG_LOG_INIT_DATA_P0<<12) + (NUM_PAG_DATA<<12)))) return -EFAULT;
	int i = 0;	
	while(i<NR_TASKS){
		if (task[i].task.pid == pid){ 
			*tics = task[i].task.cpu_time;
			return 0;
		}
		i++;
	}
	return -ESRCH; // PROCESO INEXISTENTE
}

void sys_exit() {
	
	struct task_struct* act = current();

	if (act->pid==0) return;	// EL PROCESO 0 ES INVENCIBLE :D

	// MARCAMOS COMO LIBRES EN EL BITMAP LOS FRAMES DEL PROCESO QUE SE SUICIDA
	int i;
	for (i=0;i<NUM_PAG_DATA; i++) {
		user_pages_bitmap[act->tp[i]]=FALSE;	
	}

	// CALCULAMOS LA POSICION DEL TASK_UNION DEL PROCESO ACTUAL EN EL VECTOR TASK
	void* init_task = &task[0];
	void* act_task = (void*) act;
	i = (act_task-init_task); 
	i=i/(KERNEL_STACK_SIZE*4);
	
	// MARCAMOS LA POSICIÓN DEL TASK QUE VA A SUICIDARSE COMO LIBRE EN EL BITMAP
	int j;
	for(j=0;j<((KERNEL_STACK_SIZE*4)>>12);j++) {
		task_bitmap[i+j]=FALSE;
	}

	// BORRAMOS EL PROCESO DE LA COLA RUN-READY. SI SE QUISIERA IMPLEMENTAR EL ESTADO "ZOMBIE", 
	// AQUI EL PROCESO PASARIA A LA COLA "ZOMBIE"
	union task_union* aux = (union task_union*)list_head_to_task_struct(act->lh.next);
	list_del(&act->lh, &runqueue);

	// LLAMAMOS A TASK_SWITCH() PARA QUE PASE A EJECUTAR EL SIGUIENTE PROCESO
	task_switch(aux);
}

int comprova_fd(int fd, int op){
	struct task_struct *act = current(); // act = task_struct proceso actual

	if (fd<0 || fd>NR_CHANELS) return -EBADF; // EL CANAL SE SALE DE RANGO
	if (act->tc[fd].status == CERRADO) return -EBADF; // EL CANAL ESTA CERRADO
	if (op != act->tc[fd].mode) return -EBADF; // EL CANAL NO PERMITE LA OPERACION
	
	return 0; // TODO OK
}
