#include <utils.h>
#include <segment.h>
#include <io.h>

void copy_data(void *start, void *dest, int size)
{
  DWord *p = start, *q = dest;
  while(size > 0) {
    *q++ = *p++;
    size -= 4;
  }
}

/* Copia de espacio de usuario a espacio de kernel, devuelve 0 si ok y -1 si error*/
int copy_from_user(void *start, void *dest, int size)
{
  if (((DWord)(start) < PAG_LOG_INIT_DATA_P0 << 12) || ((DWord)(start + size) > ((PAG_LOG_INIT_DATA_P0 << 12) + (NUM_PAG_DATA << 12)))) return -1;
  DWord *p = start, *q = dest;
  while(size > 0) {
    *q++ = *p++;
    size -= 4;
  }
  return 0;
}
/* Copia de espacio de kernel a espacio de usuario, devuelve 0 si ok y -1 si error*/
int copy_to_user(void *start, void *dest, int size)
{
  if (((DWord)(dest) < PAG_LOG_INIT_DATA_P0 << 12) || ((DWord)(dest + size) > ((PAG_LOG_INIT_DATA_P0 << 12) + (NUM_PAG_DATA << 12)))) return -1;
  DWord *p = start, *q = dest;
  while(size > 0) {
    *q++ = *p++;
    size -= 4;
  }
  return 0;
}

void itoa(int num, char *buffer){
	int i = 0;
	char *first, *last;
	if (num == 0) {
		buffer[0] = '0';
		buffer[1] = '\0';
		return;
	}
	if (num < 0) {	// SI ES NEGATIVO PONEMOS EL SIMBOLO -
		buffer[0] = '-';
		i = 1;
		first = &buffer[1];
	}
	else first = buffer;
	// first APUNTA AL PRIMER DIGITO DEL NUMERO
	while (num != 0){
		buffer[i] = (char)(num % 10) + '0';
		num = num / 10;
		i++;
	}
	last = &buffer[i-1];	// last APUNTA AL ULTIMO DIGITO DEL NUMERO

	while (first < last){	// DAMOS LA VUELTA AL NUMERO
		char aux = *first;
		*first = *last;
		*last = aux;
		first++; last--;
	}
	buffer[i] = '\0';	// METEMOS UN CHAR 0 AL FINAL PARA INDICAR FIN DE STRING
}

int strlen(char *buff){
	int n = 0;
	while (*buff++) n++;
	return n;
}
