#include <stdio.h>
#include <stdlib.h>
#include <readline/readline.h>
#include <locale.h>

static int fail;

int xsetlocale(const char *l)
{
	if (setlocale(LC_CTYPE, l))
		return;
	printf("Can't switch to %s locale\n", l);
	exit(1);
}

int list_size(char **m)
{
	int i;

	i = 0;
	while (*m++) ++i;
	return i;
}

int assert_size(char *s, int sz)
{
	char **m;

	m = rl_completion_matches(s, rl_filename_completion_function);
	if (list_size(m) == sz)
		return;
	fail = 1;
	printf("FAIL\n");
	printf("find %i matches, should be %i matches\n", list_size(m), sz);
}

void test_begin(char *str)
{
	int i;

	fail = 0;
	printf("%s", str);
	i = strlen(str);
	while (++i < 60)
		putchar(' ');
}

void test_ok(void)
{
	if (!fail)
		printf("OK\n");
}

void test_case_byte(void)
{
	test_begin("test case byte");

	rl_variable_bind("completion-ignore-case", "on");
	rl_variable_bind("completion-map-case", "off");
	xsetlocale("C");	

	assert_size("a", 4);

	test_ok();
}

void test_case_multi(void)
{
	test_begin("test case multi");

	rl_variable_bind("completion-ignore-case", "on");
	rl_variable_bind("completion-map-case", "off");
	xsetlocale("ru_RU.utf8");	

	assert_size("х", 4);

	test_ok();
}

void test_multi(void)
{
	test_begin("test multi");

	rl_variable_bind("completion-ignore-case", "off");
	rl_variable_bind("completion-map-case", "off");
	xsetlocale("ru_RU.utf8");	

	assert_size("х", 3);

	test_ok();
}

void test_byte(void)
{
	test_begin("test byte");

	rl_variable_bind("completion-ignore-case", "off");
	rl_variable_bind("completion-map-case", "off");
	xsetlocale("C");	

	assert_size("a", 3);

	test_ok();
}

void test_case_map_multi(void)
{
	test_begin("test case map multi");

	rl_variable_bind("completion-ignore-case", "on");
	rl_variable_bind("completion-map-case", "on");
	xsetlocale("ru_RU.utf8");	

	assert_size("г-", 3);

	test_ok();
}

void test_case_map_byte(void)
{
	test_begin("test case map byte");

	rl_variable_bind("completion-ignore-case", "on");
	rl_variable_bind("completion-map-case", "on");
	xsetlocale("C");	

	assert_size("b", 3);

	test_ok();
}

int main(void)
{
	test_byte();
	test_multi();

	test_case_byte();
	test_case_multi();

	test_case_map_byte();
	test_case_map_multi();
	return 0;
}
