# include	<sys/types.h>
# include	<sys/select.h>
# include	<sys/socket.h>
# include	<stdio.h>
# include	<netdb.h>
# include	<microhttpd.h>
# include	<getopt.h>
# include	<stdlib.h>
# include	<string.h>
# include	<glib.h>

#define PORT 8888

struct keyval {
    char *key;
    char *value;
};

struct option longopts[] = {
    { "port", required_argument, NULL, 'P' },
    { NULL, 0, NULL, 0 },
};

int
append_header_field(void *cls,
		    enum MHD_ValueKind kind,
		    const char *key,
		    const char *value)
{
    GList **listp = (GList **) cls;
    struct keyval *kv;

    kv = malloc(sizeof(struct keyval));
    kv->key = strdup(key);
    kv->value = strdup(value);

    *listp = g_list_append(*listp, kv);

    return 1;
}

void
show_header_field(gpointer p, gpointer q)
{
    struct keyval *kv = (struct keyval *) p;

    fprintf(stderr, "    %s => %s\n", kv->key, kv->value);
}

int answer_to_connection (void *cls, struct MHD_Connection *connection,
                          const char *url,
			  const char *method, const char *version,
			  const char *upload_data,
			  size_t *upload_data_size, void **con_cls)
{
    const char *page  = "<html><body>Hello, browser!</body></html>";
    struct MHD_Response *response;
    int ret;
    const char *hdr;
    GList *hdrfields;

    hdrfields = NULL;
    MHD_get_connection_values (connection, MHD_HEADER_KIND, append_header_field, &hdrfields);
    fprintf(stderr, "url=\"%s\" method=%s version=%s\n", url, method, version);
    g_list_foreach(hdrfields, show_header_field, NULL);

    response = MHD_create_response_from_buffer (strlen (page),
						(void*) page, MHD_RESPMEM_PERSISTENT);

    if ((hdr = MHD_lookup_connection_value(connection, MHD_HEADER_KIND, "Range")) != NULL)
    {
        fprintf(stderr, "\tRange=%s\n", hdr);
	MHD_add_response_header (response, "Content-Length", "10589175808");
	ret = MHD_queue_response (connection, MHD_HTTP_REQUESTED_RANGE_NOT_SATISFIABLE, response);
    }
    else
	ret = MHD_queue_response (connection, MHD_HTTP_OK, response);

    MHD_destroy_response (response);

    return ret;
}

int
main(int argc, char *argv[])
{
    int port = PORT;
    int ch;
    struct servent *se;
    struct MHD_Daemon *daemon;

    while ((ch = getopt_long(argc, argv, "P:", longopts, NULL)) != -1)
        switch (ch)
	{
	case 'P':
	    if ((se = getservbyname(optarg, "tcp")) != NULL)
	        port = ntohs(se->s_port);
	    else
	    {
		char *next;
		port = strtoul(optarg, &next, 0);
		if (next == optarg || *next != '\0')
		{
		    fprintf(stderr, "%s: bad port specification: \"%s\"\n", argv[0], optarg);
		    exit(255);
		}
	    }
	    break;
	}
    fprintf(stderr, "port = %d\n", port);

    daemon = MHD_start_daemon (MHD_USE_SELECT_INTERNALLY, port, NULL, NULL,
                                 &answer_to_connection, NULL, MHD_OPTION_END);
    if (NULL == daemon)
        exit(1);

    getchar ();

    MHD_stop_daemon (daemon);
    exit(0);
}
