package com.prototype;
import org.apache.cactus.AbstractTestCase;
import org.apache.cactus.HttpServiceDefinition;

import com.prototype.client.AbstractEJBClient;

/**
 * Prototype of EJBRedirector for Cactus.
 * @author Siddhartha P. Chandurkar (siddhartha@visioncodified.com)
 */

public abstract class AbstractEJBTestCase extends AbstractTestCase {

	public AbstractEJBTestCase(String theName) {
		super(theName);
	}

	protected void runGenericTest(AbstractEJBClient theClient)
		throws Throwable {
		EJBRequest request = new EJBRequest();
		request.setClassName(
			HttpServiceDefinition.CLASS_NAME_PARAM,
			this.getClass().getName());
		request.setMethodName(
			HttpServiceDefinition.METHOD_NAME_PARAM,
			this.getCurrentTestMethod());
		theClient.doTest(request);
	}
}
