package com.prototype;

import java.io.Serializable;
import java.util.Hashtable;

import org.apache.cactus.Request;

/**
 * Prototype of EJBRedirector for Cactus.
 * @author Siddhartha P. Chandurkar (siddhartha@visioncodified.com)
 */

public class EJBRequest implements Request, Serializable {

	private Hashtable requestMaps;

	public EJBRequest() {
		requestMaps = new Hashtable();
	}

	public void setClassName(String classKey, String name) {
		requestMaps.put(classKey, name);
	}
	public String getClassName(String classKey) {
		return (String) requestMaps.get(classKey);
	}
	public void setMethodName(String methodKey, String name) {
		requestMaps.put(methodKey, name);
	}
	public String getMethodName(String methodKey) {
		return (String) requestMaps.get(methodKey);
	}
}
