package com.prototype.client;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import com.prototype.EJBRequest;
import com.prototype.server.EJBTestRedirector;
import com.prototype.server.EJBTestRedirectorHome;

/**
 * Prototype of EJBRedirector for Cactus.
 * @author Siddhartha P. Chandurkar (siddhartha@visioncodified.com)
 */

public abstract class AbstractEJBClient {

	protected abstract String getRedirectorURL(EJBRequest theRequest);

	public void doTest(EJBRequest theRequest) throws Throwable {
		callRunTest(theRequest);
	}

	private void callRunTest(EJBRequest theRequest) throws Throwable {
		try {
			Context ctx = new InitialContext();
			EJBTestRedirectorHome home =
				(EJBTestRedirectorHome) PortableRemoteObject.narrow(
					ctx.lookup("CACTUS/EJBREDIRECTOR"),
					EJBTestRedirectorHome.class);
			EJBTestRedirector redirector = home.create();
			System.out.println("Handle Gothca !!! " + redirector);
			redirector.test(theRequest);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
