package com.prototype.server;
import java.lang.reflect.Constructor;

import org.apache.cactus.AbstractTestCase;
import org.apache.cactus.HttpServiceDefinition;
import org.apache.cactus.util.ClassLoaderUtils;

import com.prototype.EJBTestResult;

/**
 * Prototype of EJBRedirector for Cactus.
 * @author Siddhartha P. Chandurkar (siddhartha@visioncodified.com)
 */

public abstract class AbstractEJBTestCaller {

	protected EJBImplicitObjects objects;

	public AbstractEJBTestCaller(EJBImplicitObjects _objects) {
		this.objects = _objects;
	}
	protected abstract void setTestCaseFields(AbstractTestCase theTestCase)
		throws Exception;

	public void doTest() throws Exception {
		EJBTestResult result = null;

		try {

			// Create an instance of the test class
			AbstractTestCase testInstance =
				getTestClassInstance(getTestClassName(), getTestMethodName());
			System.out.println("CLASS NAME " + getTestClassName());
			System.out.println("METHOD NAME " + getTestMethodName());
			// Set its fields (implicit objects)
			setTestCaseFields(testInstance);

			// Call it's method corresponding to the current test case
			testInstance.runBareServerTest();

			// Return an instance of <code>WebTestResult</code> with a
			// positive result.
			result = new EJBTestResult();

		} catch (Throwable e) {
			// An error occurred, return an instance of
			// <code>WebTestResult</code> with an exception.
			result = new EJBTestResult(e);

		}
		System.out.println("***********************************************");
		System.out.println("Test result : [" + result + "]");
		System.out.println("***********************************************");
	}
	protected String getTestClassName() {
		return this.objects.getEJBRequest().getClassName(
			HttpServiceDefinition.CLASS_NAME_PARAM);
	}

	protected String getTestMethodName() throws Exception {
		return this.objects.getEJBRequest().getMethodName(
			HttpServiceDefinition.METHOD_NAME_PARAM);
	}

	protected AbstractTestCase getTestClassInstance(
		String theClassName,
		String theTestCaseName)
		throws Exception {
		// Get the class to call and build an instance of it.
		Class testClass = getTestClassClass(theClassName);
		AbstractTestCase testInstance = null;
		try {
			Constructor constructor =
				testClass.getConstructor(new Class[] { String.class });
			testInstance =
				(AbstractTestCase) constructor.newInstance(
					new Object[] { theTestCaseName });
		} catch (Exception e) {

			throw new Exception(e);
		}

		return testInstance;
	}

	/**
	 * @param theClassName the name of the test class
	 * @return the class object the test class to call
	 * @exception ServletException if the class of the current test case
	 *            cannot be loaded in memory (i.e. it is not in the
	 *            classpath)
	 */
	protected Class getTestClassClass(String theClassName) throws Exception {
		// Get the class to call and build an instance of it.
		Class testClass = null;
		try {
			testClass =
				ClassLoaderUtils.loadClass(theClassName, this.getClass());
		} catch (Exception e) {

			throw new Exception(e);
		}

		return testClass;
	}

}
