package com.prototype.server;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import com.prototype.EJBRequest;

/**
 * Prototype of EJBRedirector for Cactus.
 * @author Siddhartha P. Chandurkar (siddhartha@visioncodified.com)
 */

public class EJBTestRedirectorBean implements SessionBean {

	private SessionContext context;

	//Attributes

	//METHODS

	public void test(EJBRequest request) {
		try {
			System.out.println("Received request " + request);
			BeanImplicitObjects object = new BeanImplicitObjects();
			object.setEJBContext(context);
			object.setEJBRequest(request);

			EJBTestController controller = new EJBTestController();
			controller.handleRequest(object);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * No argument constructor needed by the Container
	 */
	public EJBTestRedirectorBean() {

	}
	/**
	 * Create method specified in EJB 1.1 section 6.10.3
	 */
	public void ejbCreate() throws CreateException {
	}

	/* Methods required by SessionBean Interface. EJB 1.1 section 6.5.1. */

	/**
	 * @see javax.ejb.SessionBean#setContext(javax.ejb.SessionContext)
	 */
	public void setSessionContext(SessionContext context) {
		this.context = context;
	}

	/**
	 * @see javax.ejb.SessionBean#ejbActivate()
	 */
	public void ejbActivate() {
	}

	/**
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() {
	}

	/**
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() {
	}

}
