#include <linux/bpf.h>
#include <linux/pkt_cls.h>
#include <iproute2/bpf_elf.h>

#define SEC(NAME) __attribute__((section(NAME), used))

#ifndef BPF_FUNC
# define BPF_FUNC(NAME, ...)              \
   (*NAME)(__VA_ARGS__) = (void *)BPF_FUNC_##NAME
#endif

/*
// if logging needed, include below and tail with "sudo tc exec bpf dbg"
#ifndef printk
# define printk(fmt, ...)                                      \
    ({                                                         \
        char ____fmt[] = fmt;                                  \
        trace_printk(____fmt, sizeof(____fmt), ##__VA_ARGS__); \
    })
#endif

static void BPF_FUNC(trace_printk, const char *fmt, int fmt_size, ...);
*/

SEC(ELF_SECTION_ACTION)
int act_main(struct __sk_buff *skb)
{
	// no crash without this line, and number 2 is arbitrary
	skb->tc_classid = TC_H_MAKE(TC_H_ROOT, 2);

	//printk("here!\n");

	return TC_ACT_OK;
}

char __license[] SEC(ELF_SECTION_LICENSE) = "GPL";
