<?php
$GLOBALS['THRIFT_ROOT'] = '/usr/vng/lib/thrift';

require_once $GLOBALS['THRIFT_ROOT'].'/cassandra/Cassandra.php';
require_once $GLOBALS['THRIFT_ROOT'].'/cassandra/cassandra_types.php';
require_once $GLOBALS['THRIFT_ROOT'].'/transport/TSocket.php';
require_once $GLOBALS['THRIFT_ROOT'].'/protocol/TBinaryProtocol.php';
require_once $GLOBALS['THRIFT_ROOT'].'/transport/TFramedTransport.php';
require_once $GLOBALS['THRIFT_ROOT'].'/transport/TBufferedTransport.php';

function insert_column($client, $keyspace, $key, $columnFamily,
$superColumn, $column, $value)
{
	$consistency_level = cassandra_ConsistencyLevel :: ZERO;
	$columnPath = new cassandra_ColumnPath();
	$columnPath->column_family = $columnFamily;
	$columnPath->super_column = $superColumn;
	$columnPath->column = $column;

	$timestamp = time();
	$client->insert($keyspace, $key, $columnPath, $value, $timestamp, $consistency_level);
}
function delete_column($client, $keyspace, $key, $columnFamily, $superColumn, $column)
{
	$consistency_level = cassandra_ConsistencyLevel :: ZERO;
	$columnPath = new cassandra_ColumnPath();
	$columnPath->column_family = $columnFamily;
	$columnPath->super_column = $superColumn;
	$columnPath->column = $column;

	$timestamp = time();
	$client->remove($keyspace, $key, $columnPath, $timestamp, $consistency_level);
}

function get_data_by_key($client, $keyspace, $keyId,
$columnFamily, $superColumn){
	$consistency_level = cassandra_ConsistencyLevel::ONE;

	$columnParent = new cassandra_ColumnParent();
	$columnParent->column_family = $columnFamily;
	$columnParent->super_column = $superColumn;

	$sliceRange = new cassandra_SliceRange();
	$sliceRange->start = "";
	$sliceRange->finish = "";
	$sliceRange->count = "20";
	$sliceRange->reversed = true;

	$predicate = new cassandra_SlicePredicate();
	$predicate->slice_range = $sliceRange;
	$data = $client->get_slice($keyspace, $keyId, $columnParent, $predicate,
	$consistency_level);

	return $data;
}

function getCount($client, $keyspace, $key, $columnFamily, $superColumn){
	$consistency_level = cassandra_ConsistencyLevel::ONE;

	$columnParent = new cassandra_ColumnParent();
	$columnParent->column_family = $columnFamily;
	$columnParent->super_column = $superColumn;	
	
	$data = $client->get_count($keyspace, $key, $columnParent, $consistency_level);
	
	return $data;
}

try {
	//$options = array('host'=>'10.30.12.188', "port"=>9160);
	$options = array('host'=>'127.0.0.1', "port"=>9160);

	$socket = new TSocket($options['host'], $options['port']);
	$transport = new TBufferedTransport($socket, 1024, 1024);
	$protocol = new TBinaryProtocol($transport);
	$client = new CassandraClient($protocol);
	$transport->open();

	//print_r($client->describe_keyspace("Keyspace1"));
	$start = (float) array_sum(explode(' ',microtime()));

	$userid = "user1";
	insert_column($client, "Keyspace1", $userid, "Standard1", null, "name", "User name 1");
	insert_column($client, "Keyspace1", $userid, "Standard1", null, "age", "28");
	sleep(1);
	$data = get_data_by_key(
	$client, "Keyspace1",
	$userid, "Standard1", null);
	print_r($data);
	
	print_r("---------------\n");
	print_r("After delete\n");
	//delete
	delete_column($client, "Keyspace1", $userid, "Standard1", null, "age");
	sleep(1);
	$data = get_data_by_key(
	$client, "Keyspace1",
	$userid, "Standard1", null);
	print_r($data);
	
	print_r("---------------\n");
	$data = getCount($client, "Keyspace1", $userid, "Standard1", null);
	print_r("Get_count (Should print 1, not 2)\n");
	print_r("Get_count = ");
	print_r($data."\n");

	$end = (float) array_sum(explode(' ',microtime()));
	echo "Total Processing time: ". sprintf("%.4f", (($end-$start)))." seconds";
	$transport->close();
}catch(Exception $ex){
	print 'Exception: '.$ex. ' Error: '.$ex->getMessage()."\n";
}