use strict;
use warnings;
use Test::More tests => 10;

use lib '../lib';

BEGIN { use_ok 'Catalyst::Test', 'services' }
BEGIN { use_ok 'services::Controller::Chained::empty_pathparts' }

#First make sure all the actions at least work.
ok( request('/feedrolls')->is_success, 'Request should succeed' );
ok( request('/feedrolls/new')->is_success, 'Request should succeed' );
ok( request('/feedrolls/id101')->is_success, 'Request should succeed' );
ok( request('/feedrolls/id101/new')->is_success, 'Request should succeed' );

## Next make sure that we are getting the expected values.
is( request('/feedrolls')->content,          'feedrolls_all',        'Got expected body' );
is( request('/feedrolls/new')->content,      'feedrolls_new',        'Got expected body' );
is( request('/feedrolls/id101')->content,    'feedroll_all:id101',   'Got expected body' );
is( request('/feedrolls/id101/new')->content,'feedroll_new:id101',   'Got expected body' );
