package vdc::Controller::DateField;

use warnings;
use strict;
use base 'HTML::Widget::Constraint';
use Date::Calc;

=head1 NAME

 vdc::Controller::DateField - Date Field Constraint (in just one field)

=head1 SYNOPSIS

    my $c = $widget->constraint( 'DateField', @field_names );

=head1 DESCRIPTION

Much like the 'Date' Constraint but in just one field. It ONLY
supports ISO format yyyy-mm-dd. But it's easier to deal with if you
just have single date fields.

=head1 METHODS

=head2 process

=cut

sub process {
    my ( $self, $w, $params ) = @_;

    return []
        unless ( $self->names && @{ $self->names } > 0 );

    my @names = @{ $self->names };

    my $results = [];

    foreach my $name (@names){

	my ($y,$m,$d) = split /\-/,$params->{$name};

	
	unless ( 
		 ($y =~ /^\d+$/
		  && $m =~ /^\d+$/
		  && $d =~ /^\d+$/
		  && Date::Calc::check_date( $y, $m, $d ))

		 or

		 ($params->{$name} eq '')
		 
		 )
	{
	    push @$results, HTML::Widget::Error->new(
						     { name => $name, message => $self->mk_message } );
	}
	
    }

    return $results;
}

=head1 AUTHOR

DateField Constraint by Alejandro Imass <ait@p2ee.org>

Hacked directly from Original Date by Sebastian Riedel, C<sri@oook.de>

=head1 LICENSE

This library is free software, you can redistribute it and/or modify it under
the same terms as Perl itself.

=cut

1;
