package vdc::Controller::_admin_creadores;

use strict;
use warnings;
use base 'Catalyst::Controller';
use File::Path;

=head1 NAME

vdc::Controller::_admin_creadores - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->detach('listar');
}


sub listar: Local {

    my ( $self, $c ) = @_;


    # buscar categorias en la bd (para el menu)
    $c->stash->{creadores} = [$c->model('vdcDB::creadores')
			      ->search(
				       { spl => undef },
				       { order_by => ['apellido1','nombre1'] },
				       )];
    

    # opciones de menú
    $c->stash->{opciones} = [
			     {
				 txt => 'Nuevo Creador',
				 accion => $c->uri_for('crear'),
			     },
			     {
				 txt => 'Menú Principal',
				 accion => $c->uri_for('/_admin_main'),
			     },
			     ];

    # Asociar la plantilla
    $c->stash->{template} = 'admin/creadores_lista.tt2';
    


}


sub crear: Local {
    my ($self, $c) = @_;

    # si estamos re-entrando ya viene llena
    if(!$c->stash->{widget_result}){
	my $w = $self->make_creador_widget($c);
	$w->action($c->uri_for('crear_dale'));
	$c->stash->{widget_result} = $w->result;
    }


    $c->stash->{opciones} = [
			     {
				 txt => 'Menú Principal',
				 accion => $c->uri_for('/_admin_main'),
			     },
			     {
				 txt => 'Lista de Creadores',
				 accion => $c->uri_for('listar'),
			     },
			     ];


    # Asociar la plantilla
    $c->stash->{template} = 'admin/creador_editar.tt2';


    
}


sub editar: Local {
    my ($self, $c, $id) = @_;

    my $creador = $c->model('vdcDB::creadores')
	->find({ id => $id });
    $c->stash->{creador} = $creador;
    
    
    # si estamos re-entrando ya viene llena
    if(!$c->stash->{widget_result}){
	my $w = $self->make_creador_widget($c);
	$w->action($c->uri_for("editar_dale/$id"));
	$creador->fill_widget($w);
	$c->stash->{widget_result} = $w->result;
    }
    

    $c->stash->{opciones} = [
			     {txt => 'Imagen Sinopsis',
			      accion => $c->uri_for("/_admin_creadores_imgs/editar/$id/sinopsis_imagen"),
			     },
			     {txt => 'Imagen Principal',
			      accion => $c->uri_for("/_admin_creadores_imgs/editar/$id/imagen_principal"),
			     },
			     {txt => 'Vida del Creador',
			      accion => $c->uri_for("/_admin_creadores_vida/editar/$id"),
			     },
			     {txt => 'Asociar a Categorías',
			      accion => $c->uri_for("/_admin_creadores_cats/listar/$id"),
			     },
			     {txt => 'Material del Creador',
			      accion => $c->uri_for("/_admin_creadores_material/menu/$id"),
			     },
			     {txt => 'Lista de Creadores',
			      accion => $c->uri_for('listar'),
			     },
			     {txt => 'Menú Principal',
			      accion => $c->uri_for('/_admin_main'),
			     },
			     ];


    # Asociar la plantilla
    $c->stash->{template} = 'admin/creador_editar.tt2';


}

sub eliminar: Local {
    my ($self, $c, $id) = @_;

    # buscar categorias en la bd (para el menu)
    my $creador = $c->model('vdcDB::creadores')
	->find({ id => $id });
    

    $c->stash->{confirmar_text} =
	'¿Está seguro que desea eliminar a:<br>'.
	'('.$creador->id.') '.
	$creador->apellido1.' '.
	$creador->apellido2.', '.
	$creador->nombre1.' '.
	$creador->nombre2.'?';

    $c->stash->{opcionesp} = [
			     {
				 txt => '¡Si, Eliminar Ahora!',
				 accion => $c->uri_for("eliminar_dale/$id"),
			     },

			     {
				 txt => '¡No, Volver a la Lista!',
				 accion => $c->uri_for('listar'),
			     },
			     ];

    $c->stash->{opciones} = [
			     {
				 txt => 'Menú Principal',
				 accion => $c->uri_for('/_admin_main'),
			     },
			     {
				 txt => 'Lista de Creadores',
				 accion => $c->uri_for('listar'),
			     },
			     ];

    # Asociar la plantilla
    $c->stash->{template} = 'admin/confirmar.tt2';

}

sub crear_dale : Local {
    my ($self, $c, $id) = @_;

    # para el estado y los errores
    my @status_msgs = ();
    my @error_msgs = ();

    # obtener valores de la forma
    my $nombre1 = $c->request->params->{nombre1};
    my $nombre2 = $c->request->params->{nombre2};
    my $apellido1 = $c->request->params->{apellido1};
    my $apellido2 = $c->request->params->{apellido2};
    my $fecha_nacimiento = $c->request->params->{fecha_nacimiento} || undef;
    my $fecha_muerte = $c->request->params->{fecha_muerte} || undef;
    my $sinopsis_imagen = $c->request->params->{sinopsis_imagen};
    my $sinopsis_texto = $c->request->params->{sinopsis_texto};
    my $sintesis_curricular = $c->request->params->{sintesis_curricular};
    my $imagen_principal = $c->request->params->{imagen_principal};


    # crear el widget
    my $w = $self->make_creador_widget($c);
    $w->action($c->uri_for('crear_dale'));
    
    # validar los datos
    my $result = $w->process($c->req);
    
    # guardar el resultado
    $c->stash->{widget_result} = $result;
    
    
    # ¿hay errores?
    if ($result->has_errors) {

	push @error_msgs, '¡Hay errores en la data!';
	push @status_msgs, '¡No se actualizó el registro!';

	# estado y errores
	$c->stash->{status_msgs} = \@status_msgs;
	$c->stash->{error_msgs} = \@error_msgs;

	# volver al modo crear ya que aún no hay registro en la bd
	$c->detach('crear');

    } else {

	# si todo salió bien entonces actualizar el registro en la bd...
	my $creador = $c->model('vdcDB::creadores')->create({
	    nombre1 => $nombre1,
	    nombre2 => $nombre2,
	    apellido1 => $apellido1,
	    apellido2 => $apellido2,
	    fecha_nacimiento => $fecha_nacimiento,
	    fecha_muerte => $fecha_muerte,
	    sinopsis_texto => $sinopsis_texto,
	    sintesis_curricular => $sintesis_curricular,
	});

	push @status_msgs, 'REGISTRO ACTUALIZADO!';
	
	# estado y errores
	$c->stash->{status_msgs} = \@status_msgs;
	$c->stash->{error_msgs} = \@error_msgs;

	# en este caso vamos a editar ya que el registro ya existe en la bd
	$c->detach('editar', [$creador->id]);
	
    }
	

}



sub editar_dale : Local {
    my ($self, $c, $id) = @_;

    # para el estado y los errores
    my @status_msgs = ();
    my @error_msgs = ();

    # obtener valores de la forma
    my $nombre1 = $c->request->params->{nombre1};
    my $nombre2 = $c->request->params->{nombre2};
    my $apellido1 = $c->request->params->{apellido1};
    my $apellido2 = $c->request->params->{apellido2};
    my $fecha_nacimiento = $c->request->params->{fecha_nacimiento} || undef;
    my $fecha_muerte = $c->request->params->{fecha_muerte} || undef;
    my $sinopsis_imagen = $c->request->params->{sinopsis_imagen};
    my $sinopsis_texto = $c->request->params->{sinopsis_texto};
    my $sintesis_curricular = $c->request->params->{sintesis_curricular};
    my $imagen_principal = $c->request->params->{imagen_principal};

    # crear el widget
    my $w = $self->make_creador_widget($c);
    $w->action($c->uri_for("editar_dale/$id"));
    
    # validar los datos
    my $result = $w->process($c->req);
    
    # guardar el resultado
    $c->stash->{widget_result} = $result;
    
    my $creador = $c->model('vdcDB::creadores')
	->find({ id => $id });
    $c->stash->{creador} = $creador;	
    
    # ¿hay errores?
    if ($result->has_errors) {

	push @error_msgs, '¡Hay errores en la data!';
	push @status_msgs, '¡No se actualizó el registro!';

	# estado y errores
	$c->stash->{status_msgs} = \@status_msgs;
	$c->stash->{error_msgs} = \@error_msgs;


    } else {

	# si todo salió bien entonces actualizar el registro en la bd...
	$creador->set_columns({
	    nombre1 => $nombre1,
	    nombre2 => $nombre2,
	    apellido1 => $apellido1,
	    apellido2 => $apellido2,
	    fecha_nacimiento => $fecha_nacimiento || undef,
	    fecha_muerte => $fecha_muerte || undef,
	    sinopsis_imagen => $sinopsis_imagen,
	    sinopsis_texto => $sinopsis_texto,
	    sintesis_curricular => $sintesis_curricular,
	    imagen_principal => $imagen_principal,
	});
	
	$creador->update();
	
	push @status_msgs, 'REGISTRO ACTUALIZADO!';
	
	# estado y errores
	$c->stash->{status_msgs} = \@status_msgs;
	$c->stash->{error_msgs} = \@error_msgs;

	
    }
	
    $c->detach('editar', [$id]);
}


sub eliminar_dale : Local {
    my ($self, $c, $id) = @_;

    # para el estado y los errores
    my @status_msgs = ();
    my @error_msgs = ();


    # buscar categorias en la bd (para el menu)
    my $creador = $c->model('vdcDB::creadores')
	->find({ id => $id });

    # eliminar todo de la biblioteca del creador
    # ruta 
    my $path = 
	$c->config->{biblioteca}.'/'.
	$c->config->{dir_creadores}.'/'.
	$creador->id.'/';

    rmtree($path) 
	or push @error_msgs, "Error al eliminar los archivos de la biblioteca: $!";

    # notar el orden del borrado!
    
    # (1) borrar registros del material del creador de la bd
    my $material = [$c->model('vdcDB::material')
		   ->search({ id_creador => $creador->id })];
    foreach my $mat (@$material){
	if(defined $mat){
	    $mat->delete();
	}
    }


    # (2) borrar registros de categoría del creador de la bd
    my $subcats = [$c->model('vdcDB::sub_categorias_creadores')
		   ->search({ id_creador => $creador->id })];
    foreach my $subcat (@$subcats){
	if(defined $subcat){
	    $subcat->delete();
	}
    }

    # (3) borrar el creador de la bd (ojo FK abajo!)
    $creador->delete();

    # (4) finalmente, borrar registros de vida del creador de la bd
    # notar que $creador aun existe aquí pero no en la bd 
    # mayor info ver: perldoc DBIx::Class::Row -> delete
    my $vida = $c->model('vdcDB::vida_creador')
	->find({ id => $creador->vida });
    if(defined $vida){
	$vida->delete();
    }

    push @status_msgs, "Creador ($id) y toda su data eliminado permanentemente de la base de datos!";

    # estado y errores
    $c->stash->{status_msgs} = \@status_msgs;
    $c->stash->{error_msgs} = \@error_msgs;

    $c->detach('listar');


}

sub make_creador_widget : Private {
    my ($self, $c) = @_;
    
    my $w = $c->widget('creador_form')
	->method('post');
    
    $w->element('Textfield', 'nombre1' )->label('Nombre 1')->size(40);
    $w->element('Textfield', 'nombre2' )->label('Nombre 2')->size(40);
    $w->element('Textfield', 'apellido1' )->label('Apellido 1')->size(40);
    $w->element('Textfield', 'apellido2' )->label('Apellido 2')->size(40);
    $w->element('Textfield', 'fecha_nacimiento' )->label('Fecha Nacimiento')->size(40);
    $w->element('Textfield', 'fecha_muerte' )->label('Fecha Muerte')->size(40);
    $w->element('Textarea', 'sinopsis_texto' )
	->label('Texto de la Sinopsis')
	->cols(65)
	->rows(10);
    $w->element('Textarea', 'sintesis_curricular' )
	->label('Síntesis Curricular')
	->cols(65)
	->rows(10);

    $w->element('Submit', 'submit' )->value('Actualizar BD');


    # constraints
    $w->constraint(All => qw/apellido1 nombre1/)
	->message('Requerido');
    $w->constraint("+vdc::Controller::DateField" => qw/ fecha_nacimiento fecha_muerte /)
	->message('Formato: AAAA-MM-DD');
    
    for my $column (qw/sinopsis_texto sintesis_curricular/) {
	$w->filter( HTMLEscape => $column );
	$w->filter( TrimEdges  => $column );
    }

    # Return the widget
    return $w;
    
}






=head1 AUTHOR

Alejandro Imass,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
