package vdc::Controller::_admin_creadores_cats;

use strict;
use warnings;
use base 'Catalyst::Controller';

=head1 NAME

vdc::Controller::_admin_creadores_cats - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->detach('listar');

}


sub listar: Local {

    my ( $self, $c, $id ) = @_;

    $c->stash->{creador} = $c->model('vdcDB::creadores')
	->find({ id => $id });
    
    
    $c->stash->{subcats_creador} = [$c->model('vdcDB::sub_categorias_creadores')
				    ->search(
					     { 
						 id_creador => $id,
					     },
					     { 
						 join => {'sub_categorias' => 'categorias'},
						 prefetch => {'sub_categorias' => 'categorias'},
					     },
					     )];

    my $w = $self->make_creador_cats_widget($c);
    $w->action($c->uri_for("process/$id"));
    $c->stash->{widget_result} = $w->result;
    
    # opciones comunes
    $c->stash->{opciones} = [
			     {
				 txt => 'Editar Creador',
				 accion => $c->uri_for("/_admin_creadores/editar/$id"),
			     },
			     {
				 txt => 'Menú Principal',
				 accion => $c->uri_for('/_admin_main'),
			     },
			     {
				 txt => 'Lista de Creadores',
				 accion => $c->uri_for('/_admin_creadores'),
			     },
			     ];
    
    # Asociar la plantilla
    $c->stash->{template} = 'admin/creador_subcat.tt2';
    


}


sub process : Local {
    my ($self, $c, $id) = @_;

    # para el estado y los errores
    my @status_msgs = ();
    my @error_msgs = ();

    # la subcategoría fue seleccionada... es hora de añadir la subcat
    if($c->request->params->{sub_categorias}){

	my $subcat_creador = $c->model('vdcDB::sub_categorias_creadores')->create({
	    id_creador => $id,
	    id_sub_categoria => $c->request->params->{sub_categorias},
	    especializacion => $c->request->params->{especializacion},
	});

	
	# Set a status message for the user
	push @status_msgs, '¡REGISTRO ACTUALIZADO!';
	

    }
    # la categoría fue seleccionada... mostrar sub cats
    else{
	($c->stash->{cat_selected_id},$c->stash->{cat_selected_nombre}) 
	    = split /\_\_/,$c->request->params->{categorias};

    }

    $c->stash->{status_msgs} = \@status_msgs;
    $c->stash->{error_msgs} = \@error_msgs;

    $c->detach('listar', [$id]);

}


sub eliminar : Local {
    my ($self, $c, $id, $id_subcat) = @_;

    # no hay warning, dale!

    # para el estado y los errores
    my @status_msgs = ();
    my @error_msgs = ();

    my $subcat_creador = $c->model('vdcDB::sub_categorias_creadores')
	->find(
	       { 
		   id_creador => $id,
		   id_sub_categoria => $id_subcat,
		   
	       });
    
    $subcat_creador->delete();

    push @status_msgs, "Asociación eliminada permanentemente de la base de datos!";

    $c->stash->{status_msgs} = \@status_msgs;
    $c->stash->{error_msgs} = \@status_msgs;

    $c->detach('listar', [$id]);

}


sub make_creador_cats_widget : Private {
    my ($self, $c) = @_;
    
    my $w = $c->widget('creador_cats_form')
	->method('post');

    my ($cat_selected_id, $cat_selected_nombre) = '';
    if($cat_selected_id = $c->stash->{cat_selected_id}){

	$cat_selected_nombre = $c->stash->{cat_selected_nombre};

	my @subcat_list = map {$_->id => $_->nombre} 
	$c->model('vdcDB::sub_categorias_creador_v1')
	    ->search(
		     {
			 id_categoria => $cat_selected_id,
			 id_creador => {'!=', $c->stash->{creador}->id},
			 id_creador => undef,
		     },
		     );    
	$w->element('Select', 'sub_categorias' )->label($cat_selected_nombre."->")->options(@subcat_list);
	$w->element('Textfield', 'especializacion' )->label('Especialización')->size(40);

    }
    else {
	my @cat_list = map {$_->id.'__'.$_->nombre => $_->nombre} $c->model('vdcDB::categorias')->all;    
	$w->element('Select', 'categorias' )->label('Categoría')->options(@cat_list);
    }


    $w->element('Submit', 'submit' )->value('Actualizar BD');

    return $w;

}

=head1 AUTHOR

root

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
