package vdc::Controller::_admin_creadores_imgs;

use strict;
use warnings;
use base 'Catalyst::Controller';
use Image::Magick;
use File::Basename;
use File::Path;

=head1 NAME

vdc::Controller::_admin_creadores_imgs - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->response->body('Matched vdc::Controller::_admin_creadores_imgs in _admin_creadores_imgs.');
}


sub editar : Local {

    my ( $self, $c, $id, $cual ) = @_;

    my $creador = $c->model('vdcDB::creadores')
	->find({ id => $id });
    $c->stash->{creador} = $creador;
    
    
    # si estamos re-entrando ya viene llena
    if(!$c->stash->{widget_result}){

	my $w = $self->make_creador_img_widget($c, $cual);

	$w->action($c->uri_for("editar_dale/$id/$cual"));
	
	my $e = $w->get_element(name => 'imagen_img');

	my $img = $creador->$cual || 'catalyst_logo.png';
	my $path = $c->req->base.(
				  $img eq 'catalyst_logo.png' ? 
				  'static/images' : 
				  "static/biblioteca/creadores/$id/".$c->config->{fotos}
				  );

	$e->content(HTML::Element->new('img', src => "$path/$img", width => '150', height => '150'));

	$creador->fill_widget($w);
	$w->get_element(name => $cual.'_v')->value($creador->$cual);
	$c->stash->{widget_result} = $w->result;
    }



    # opciones comunes
    $c->stash->{opciones} = [
			     {
				 txt => 'Editar Creador',
				 accion => $c->uri_for("/_admin_creadores/editar/$id"),
			     },
			     {
				 txt => 'Menú Principal',
				 accion => $c->uri_for('/_admin_main'),
			     },
			     {
				 txt => 'Lista de Creadores',
				 accion => $c->uri_for('/_admin_creadores'),
			     },
			     ];
    


    # Asociar la plantilla
    $c->stash->{template} = 'admin/creador_editar.tt2';




}


sub editar_dale : Local {
    my ($self, $c, $id, $cual) = @_;

    # para el estado y los errores
    my @status_msgs = ();
    my @error_msgs = ();

    # obtener info del creador
    my $creador = $c->model('vdcDB::creadores')
	->find({ id => $id });
    $c->stash->{creador} = $creador;	


    # si hay que cambiar la imagen...
    if ( my $upload = $c->request->upload('imagen_nueva') ) {
	
	# nombre básico del archivo
	my $filename = $upload->filename;


	# ruta 
	my $path = 
	    $c->config->{biblioteca}.'/'.
	    $c->config->{dir_creadores}."/$id/".
	    $c->config->{fotos};
	
	# target
	my $target = $path."/$filename";

	# verificar / crear ruta
	mkpath($path,0,0755) unless stat($path);

	# subir el archivo
	if ( $upload->link_to($target) || $upload->copy_to($target) ) {

	    # nombre del archivo viejo
	    my $org_filename = $c->request->params->{$cual} || undef;
	    
	    # mensaje al usuario
	    push @status_msgs, "Se copió $filename a $target";

	    # en este punto debemos actualizar la BD
	    if($cual eq 'sinopsis_imagen'){
		$creador->set_columns({sinopsis_imagen => $filename});
	    }
	    if($cual eq 'imagen_principal'){
		$creador->set_columns({imagen_principal => $filename});
	    }

	    $creador->update();

	    # borrar los anteriores
	    if($org_filename){
		
		$org_filename =~ /(.*)\..*/;
		my $del_str = $path.'/'.$1.'*';
		
		opendir(DIR, $path);
		my @files = grep { /^$1.*$/ } readdir(DIR);
		closedir(DIR);

		foreach my $file (@files){
		    unlink $path.'/'.$file
			or push @error_msgs, "No se pudo borrar el archivo viejo ($file): $!";
		}

		push @status_msgs, "Se borraron los archivos viejos ($del_str)";

	    }



	    # ajustar la imagen para la aplicación
	    push @status_msgs, 
	    $self->process_img($c, $target, $cual, \@status_msgs, \@error_msgs);
	
	}
	else {

	    push @error_msgs, "No se pudo copiar $filename a $target : $!";

	}
	
	$c->stash->{status_msgs} = \@status_msgs;
	$c->stash->{error_msgs} = \@error_msgs;	
    }
    
    $c->detach('editar', [$id, $cual]);

}


sub make_creador_img_widget : Private {

    my ($self, $c, $cual) = @_;
    
    my $w = $c->widget('creador_img_form')
	->method('post');
    
    $w->element('Span', 'imagen_img');

    $w->element('Hidden', $cual );

    $w->element('Textfield', $cual.'_v' )->label('Archivo Actual')->size(40)->attrs->{disabled} = 'disabled';

    $w->element('Upload', 'imagen_nueva' )->label('Nuevo Archivo')->size(40);

    $w->element('Submit', 'submit' )->value('Actualizar BD');


    # Return the widget
    return $w;
    
}


sub process_img : Private {

    my ($self, $c, $target, $cual, $status_msgs, $error_msgs) = @_;

    my ($base, $path, $type) = fileparse($target,qr{\..*});
    
    my $img_base = Image::Magick->new;

    unless($img_base->Read(filename=>$target) > 0){
	push @$error_msgs, "No se pudo leer $target: $!";
	return;
    }

    # proporciones de la imagen
    my $width = $img_base->Get('width');
    my $height = $img_base->Get('height');
    my $prop = $width/$height;

    my ($x, $y, $new_w, $new_h) = 0;

    # si la proporción está fuera del rango...
    unless($c->config->{img_prop_min} <= $prop && $prop <= $c->config->{img_prop_max}){
	
	# ajustar la altura...
	if($height >= $width){

	    # nuevas domensiones
	    $new_w = $width;
	    $new_h = $width/$c->config->{img_prop_ideal};

	    # offset
	    $x = 0;
	    $y = ($height/2) - ($new_h/2);

	    push @$status_msgs, "Por proporción se ajustó la altura a $new_h";

	}
	# ajustar el ancho...
	else {
	    
	    # nuevas dimensiones
	    $new_w = $height * $c->config->{img_prop_ideal};
	    $new_h = $height;

	    # offset
	    $x = ($width/2) - ($new_w/2);
	    $y = 0;

	    push @$status_msgs, "Por proporción se ajustó el ancho a $new_h";
	    
	}
	
	# ejecutar el crop
	$img_base->Crop(
			width => $new_w,
			height => $new_h,
			x => $x,
			y => $y,
			);

    }

    # en este punto tenemos la imagen con la prop correcta...
    # ahora tenemos que generar los tamaños correctos

    # para el nuevo nombre
    my $new_ext = '';

    if($cual eq 'sinopsis_imagen'){

	$new_w = $c->config->{sinopsis_imagen_w};
	$new_h = $new_w / $c->config->{img_prop_ideal};
	$new_ext = $c->config->{sinopsis_ext};

    }

    if($cual eq 'imagen_principal'){

	$new_w = $c->config->{imagen_principal_w};
	$new_h = $new_w / $c->config->{img_prop_ideal};
	$new_ext = $c->config->{principal_ext};

    }

    # escalar la imagen para su uso
    $img_base->Scale(width => $new_w, height => $new_h);

    $img_base->Write(filename => $path.$base.$new_ext);

    push @$status_msgs, "Se escaló el tamaño para la '$cual'";
    
    return;

}

=head1 AUTHOR

Alejandro Imass,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
