package vdc::Controller::_admin_creadores_material;

use strict;
use warnings;
use base 'Catalyst::Controller';
use Image::Magick;
use File::Basename;
use File::Path;

=head1 NAME

vdc::Controller::_admin_creadores_material - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->detach('menu');

}

sub menu : Local {
    my ( $self, $c, $id_creador ) = @_;

    # setea el despliegue de la forma
    $c->stash->{crud_status} = 'menu';

    $c->stash->{id_creador} = $id_creador;

    # opciones comunes
    $c->stash->{opciones} = [
			     {
				 txt => 'Editar Creador',
				 accion => $c->uri_for("/_admin_creadores/editar/$id_creador"),
			     },
			     {
				 txt => 'Menú Principal',
				 accion => $c->uri_for('/_admin_main'),
			     },
			     {
				 txt => 'Lista de Creadores',
				 accion => $c->uri_for('/_admin_creadores'),
			     },
			     ];


    $c->stash->{template} = 'admin/creador_material.tt2';
    
}


sub listar: Local {

    my ( $self, $c, $id_creador, $tipo ) = @_;

    # setea el despliegue de la forma
    $c->stash->{crud_status} = 'listar';


    $c->stash->{creador} = $c->model('vdcDB::creadores')
	->find({ id => $id_creador });
    
    
    $c->stash->{material} = [$c->model('vdcDB::material')
			     ->search(
				      { 
					  id_creador => $id_creador,
					  tipo => $tipo,
				      })];
    
    $c->stash->{opciones} = [
			     {
				 txt => 'Nuevo Material',
				 accion => $c->uri_for("crear/$id_creador/$tipo"),
			     },
			     {
				 txt => 'Editar Creador',
				 accion => $c->uri_for("/_admin_creadores/editar/$id_creador"),
			     },
			     {
				 txt => 'Menú Principal',
				 accion => $c->uri_for('/_admin_main'),
			     },
			     {
				 txt => 'Lista de Creadores',
				 accion => $c->uri_for('/_admin_creadores'),
			     },

			     ];


    # Asociar la plantilla
    $c->stash->{template} = 'admin/creador_material.tt2';
    


}

sub editar: Local {
    my ($self, $c, $id_material) = @_;

    # setea el despliegue de la forma
    $c->stash->{crud_status} = 'editar';
    
    my $material = $c->model('vdcDB::material')
	->find({ id => $id_material });
    $c->stash->{material} = $material;

    my $id_creador = $material->id_creador;
    my $tipo = $material->tipo;

    my $creador = $c->model('vdcDB::creadores')
	->find({ id =>  $id_creador });
    $c->stash->{creador} = $creador;

    
    # si estamos re-entrando ya viene llena
    unless($c->stash->{widget_result}){

	# crear el widget
	my $w = $self->make_creador_mat_widget($c);

	# asociar la acción
	$w->action($c->uri_for("editar_dale/$id_material"));


	# refill del widget (bug de HTML::Widget con los disabled)
	$material->fill_widget($w);
	$w->get_element(name => 'archivo_v')->value($material->archivo);
	$c->stash->{widget_result} = $w->result;
    }
    

    $c->stash->{opciones} = [
			     {
				 txt => 'Lista del Material',
				 accion => $c->uri_for("listar/$id_creador/$tipo"),
			     },
			     {
				 txt => 'Editar Creador',
				 accion => $c->uri_for("/_admin_creadores/editar/$id_creador"),
			     },
			     {
				 txt => 'Menú Principal',
				 accion => $c->uri_for('/_admin_main'),
			     },
			     {
				 txt => 'Lista de Creadores',
				 accion => $c->uri_for('/_admin_creadores'),
			     },
			     ];


    # Asociar la plantilla
    $c->stash->{template} = 'admin/creador_material.tt2';

}

sub crear: Local {
    my ($self, $c, $id_creador, $tipo) = @_;

    # setea el despliegue de la forma
    $c->stash->{crud_status} = 'crear';


    # si estamos re-entrando ya viene llena
    unless($c->stash->{widget_result}){
	my $w = $self->make_creador_mat_widget($c);
	$w->action($c->uri_for('crear_dale'));

	# completar los campos escondidos al usuario
	$w->element('Hidden', 'id_creador')->value($id_creador);
	$w->element('Hidden', 'tipo')->value($tipo);

	$c->stash->{widget_result} = $w->result;
    }


    $c->stash->{opciones} = [
			     {
				 txt => 'Lista del Material',
				 accion => $c->uri_for("listar/$id_creador/$tipo"),
			     },
			     {
				 txt => 'Editar Creador',
				 accion => $c->uri_for("/_admin_creadores/editar/$id_creador"),
			     },
			     {
				 txt => 'Menú Principal',
				 accion => $c->uri_for('/_admin_main'),
			     },
			     {
				 txt => 'Lista de Creadores',
				 accion => $c->uri_for('/_admin_creadores'),
			     },
			     ];




    # Asociar la plantilla
    $c->stash->{template} = 'admin/creador_material.tt2';
    
}

sub eliminar : Local {
    my ($self, $c, $id_material) = @_;

    # no hay warning, dale!

    # para el estado y los errores
    my @status_msgs = ();
    my @error_msgs = ();

    # obtener material
    my $material = $c->model('vdcDB::material')
	->find({ id => $id_material });
    $c->stash->{material} = $material;

    my $id_creador = $material->id_creador;
    my $tipo = $material->tipo;

    # ruta 
    my $path = 
	$c->config->{biblioteca}.'/'.
	$c->config->{dir_creadores}.'/'.
	$id_creador.'/'.
	$tipo;
    

    $material->archivo =~ /(.*)\..*/;
    my $del_str = $path.'/'.$1.'*';
    
    opendir(DIR, $path);
    my @files = grep { /^$1.*$/ } readdir(DIR);
    closedir(DIR);
    
    foreach my $file (@files){
	unlink $path.'/'.$file
	    or push @error_msgs, "No se pudo borrar el archivo viejo ($file): $!";
    }
    push @status_msgs, "Se borraron los archivos viejos ($del_str)";

    $material->delete();

    push @status_msgs, "Se eliminó el registro permanentemente de la base de datos y de la biblioteca, ";

    $c->stash->{status_msgs} = \@status_msgs;
    $c->stash->{error_msgs} = \@error_msgs;

    $c->detach('listar', [$id_creador, $tipo]);

}

sub crear_dale : Local {
    my ($self, $c, $id_material) = @_;

    # para el estado y los errores
    my @status_msgs = ();
    my @error_msgs = ();

    # obtener valores de la forma
    my $id_creador = $c->request->params->{id_creador};
    my $tipo = $c->request->params->{tipo};
    my $clase = $c->request->params->{clase};
    my $grupo = $c->request->params->{grupo};
    my $titulo = $c->request->params->{titulo};
    my $tecnica = $c->request->params->{tecnica};
    my $dimensiones = $c->request->params->{dimensiones};
    my $fecha_obra = $c->request->params->{fecha_obra};
    my $nota1 = $c->request->params->{nota1};
    my $nota2 = $c->request->params->{nota2};
    my $nota3 = $c->request->params->{nota3};


    # crear el widget
    my $w = $self->make_creador_mat_widget($c);
    $w->action($c->uri_for('crear_dale'));
    
    # validar los datos
    my $result = $w->process($c->req);
    
    # guardar el resultado
    $c->stash->{widget_result} = $result;
    
    
    # ¿hay errores?
    if ($result->has_errors) {

	# informar al usuario sobre los errores
	push @error_msgs, '¡Hay errores en la data!';

	# Set a status message for the user
	push @status_msgs, '¡No se actualizó el registro!';

	# mensajes y errores
	$c->stash->{status_msgs} = \@status_msgs;
	$c->stash->{error_msgs} = \@error_msgs;

	# volvemos a crear porque aún no hay registro en la bd
	$c->detach('crear');


    } else {

	# si todo salió bien entonces actualizar el registro en la bd...

	my $material = $c->model('vdcDB::material')->create({
	    id_creador => $id_creador,
	    tipo => $tipo,
	    clase => $clase,
	    grupo => $grupo,
	    titulo => $titulo,
	    tecnica => $tecnica,
	    dimensiones => $dimensiones,
	    fecha_obra => $fecha_obra,
	    nota1 => $nota1,
	    nota2 => $nota2,
	    nota3 => $nota3,
	});


	# guardar en el stash
	$c->stash->{material} = $material;
	
	# procesar el upload de existir
	$self->upload_handler($c, \@status_msgs, \@error_msgs);

	# Mensaje al usuario
	push @status_msgs, 'REGISTRO ACTUALIZADO!';

	# si estamos aquí ya no es crear, es editar!
	$w->action($c->uri_for('editar_dale'));

	# refill del widget (bug de HTML::Widget con los disabled)
	$material->fill_widget($w);
	$w->get_element(name => 'archivo_v')->value($material->archivo);
	$c->stash->{widget_result} = $w->result;
	
	# mensajes y errores
	$c->stash->{status_msgs} = \@status_msgs;
	$c->stash->{error_msgs} = \@error_msgs;

	# aquí editamos porque el registro ya existe en la bd
	$c->detach('editar', [$material->id]);
	
    }
	

}



sub editar_dale : Local {
    my ($self, $c, $id_material) = @_;

    # para el estado y los errores
    my @status_msgs = ();
    my @error_msgs = ();

    # datos del material
    my $material = $c->model('vdcDB::material')
	->find({ id => $id_material });
    $c->stash->{material} = $material;	

    # obtener valores de la forma
    my $clase = $c->request->params->{clase};
    my $grupo = $c->request->params->{grupo};
    my $titulo = $c->request->params->{titulo};
    my $tecnica = $c->request->params->{tecnica};
    my $dimensiones = $c->request->params->{dimensiones};
    my $fecha_obra = $c->request->params->{fecha_obra};
    my $nota1 = $c->request->params->{nota1};
    my $nota2 = $c->request->params->{nota2};
    my $nota3 = $c->request->params->{nota3};

    # crear el widget
    my $w = $self->make_creador_mat_widget($c);
    $w->action($c->uri_for("editar_dale/$id_material"));

    # validar los datos
    my $result = $w->process($c->req);
    
    # guardar el resultado
    $c->stash->{widget_result} = $result;
    
    
    # ¿hay errores?
    if ($result->has_errors) {

	# informar al usuario sobre los errores
	push @error_msgs, '¡Hay errores en la data!';

	# Set a status message for the user
	push @status_msgs, '¡No se actualizó el registro!';


    } else {

	# si todo salió bien entonces actualizar el registro en la bd...
	
	$material->set_columns({
	    clase => $clase,
	    grupo => $grupo,
	    titulo => $titulo,
	    tecnica => $tecnica,
	    dimensiones => $dimensiones,
	    fecha_obra => $fecha_obra,
	    nota1 => $nota1,
	    nota2 => $nota2,
	    nota3 => $nota3,
	});
	
	$material->update();
	
	$c->stash->{material} = $material;

	# procesar el upload de existir
	$self->upload_handler($c, \@status_msgs, \@error_msgs);

	# mensaje de estatus
	push @status_msgs, '¡REGISTRO ACTUALIZADO!';

	# refill del widget (bug de HTML::Widget con los disabled)
	$material->fill_widget($w);
	$w->get_element(name => 'archivo_v')->value($material->archivo);
	$c->stash->{widget_result} = $w->result;
	
	
    }

    # mensajes y errores
    $c->stash->{status_msgs} = \@status_msgs;
    $c->stash->{error_msgs} = \@error_msgs;
	
    $c->detach('editar', [$id_material]);
}



sub make_creador_mat_widget : Private {

    my ($self, $c) = @_;
    
    my $w = $c->widget('creador_mat_form')
	->method('post');
    

    my @clase_list = map {$_->id => $_->descripcion} 
    $c->model('vdcDB::clase_material')->all;
    $w->element('Select', 'clase' )
	->label('Clase')->options(@clase_list);
    

    $w->element('Textfield', 'grupo' )->label('Grupo')->size(40);
    $w->element('Textfield', 'archivo_v' )->label('Archivo')->size(40)->attrs->{disabled} = 'disabled';
    $w->element('Hidden', 'archivo');
    $w->element('Upload', 'archivo_nuevo' )->label('Subir Archivo')->size(40);
    $w->element('Textfield', 'titulo' )->label('Titulo')->size(40);
    $w->element('Textfield', 'tecnica' )->label('Tecnica')->size(40);
    $w->element('Textfield', 'dimensiones' )->label('Dimensiones')->size(40);
    $w->element('Textfield', 'fecha_obra' )->label('Fecha Obra')->size(40);
    $w->element('Textfield', 'nota1' )->label('Nota 1')->size(40);
    $w->element('Textfield', 'nota2' )->label('Nota 2')->size(40);
    $w->element('Textfield', 'nota3' )->label('Nota 3')->size(40);

    $w->element('Submit', 'submit' )->value('Actualizar BD');

    # constraints
    $w->constraint("+vdc::Controller::DateField" => qw/ fecha_obra /)
	->message('Formato: AAAA-MM-DD');


    # Return the widget
    return $w;
    
}


sub upload_handler : Private {

    my ($self, $c, $status_msgs, $error_msgs) = @_;

    # si hay que cambiar el archivo...
    if ( my $upload = $c->request->upload('archivo_nuevo') ) {
	
	# nombre básico del archivo
	my $filename = $upload->filename;

	# nombre del archivo viejo
	my $org_filename = $c->request->params->{archivo} || undef;

	# ruta 
	my $path = 
	    $c->config->{biblioteca}.'/'.
	    $c->config->{dir_creadores}.'/'.
	    $c->stash->{material}->id_creador.'/'.
	    $c->stash->{material}->tipo;


	# borrar los anteriores
	if($org_filename){
	    
	    $org_filename =~ /(.*)\..*/;
	    my $del_str = $path.'/'.$1.'*';
	    
	    opendir(DIR, $path);
	    my @files = grep { /^$1.*$/ } readdir(DIR);
	    closedir(DIR);

	    foreach my $file (@files){
		unlink $path.'/'.$file
		    or push @$error_msgs, "No se pudo borrar el archivo viejo ($file): $!";
	    }
	    push @$status_msgs, "Se borraron los archivos viejos ($del_str)";

	}
	
	# target
	my $target = $path."/$filename";

	# verificar / crear ruta
	mkpath($path,0,0755) unless stat($path);

	# subir el archivo
	if ( $upload->link_to($target) || $upload->copy_to($target) ) {
	    
	    # subió bien, ahora a procesar la imagen
	    push @$status_msgs, "Se copió $filename a $target";

	    $c->stash->{material}->set_columns({archivo => $filename});

	    $c->stash->{material}->update();

	    # post-procesamiento del archivo
	    if($c->stash->{material}->tipo eq $c->config->{fotos}){
		$self->process_img($c, $target, $status_msgs, $error_msgs);
	    }
	
	}
	else {

	    push @$error_msgs, "No se pudo copiar $filename a $target : $!";

	}
	
    }
    
    return;

}


sub process_img : Private {

    my ($self, $c, $target, $status_msgs, $error_msgs) = @_;

    my ($base, $path, $type) = fileparse($target,qr{\..*});
    
    my $img_base = Image::Magick->new;
    my $img_water = Image::Magick->new;

    unless($img_base->Read(filename=>$target) > 0){
	push @$error_msgs, "No se pudo leer $target: $!";
	return;
    }
    else{
	$img_water->Read(filename=>$target);
    }

    # proporciones de la imagen
    my $width = $img_base->Get('width');
    my $height = $img_base->Get('height');
    my $prop = $width/$height;

    my ($new_w, $new_h) = 0;

    # imagen con marca de agua
    my $water = Image::Magick->new;
    $water->Read(filename => $c->config->{watermark_file});
    my $water_w = $width*$c->config->{watermark_size};
    my $water_h = $water_w * $prop;
    $img_water->Composite(image=>$water, compose=>'Atop', geometry=>$water_w.'x'.$water_h);
    $img_water->Write(filename => $path.$base.$c->config->{water_ext});

    push @$status_msgs, "Se creó la imagen con marca de agua";
    
    
    # crear browse
    if($width > $c->config->{browse_imagen_max_w}){

	$new_w = $c->config->{browse_imagen_max_w};
	$new_h = $new_w / $prop;
    }
    else {

	$new_w = $width;
    }

    if($height > $c->config->{browse_imagen_max_h}){

	$new_h = $c->config->{browse_imagen_max_h};
	$new_w = $new_h * $prop;

    }
    else {
	
	$new_h = $height;
	
    }

    # escalar la imagen para su uso
    $img_base->Scale(width => $new_w, height => $new_h);
    $img_base->Write(filename => $path.$base.$c->config->{browse_ext});

    push @$status_msgs, "Se creó la imagen para visualizar";
    
    # crear thumb
    $new_w = $c->config->{thumb_width};
    $new_h = $new_w / $prop;
    $img_base->Scale(width => $new_w, height => $new_h);
    $img_base->Write(filename => $path.$base.$c->config->{thumb_ext});

    push @$status_msgs, "Se creó el 'thumbnail'";
    
    return;

}


=head1 AUTHOR

Alejandro Imass,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
