package vdc::Controller::_admin_creadores_vida;

use strict;
use warnings;
use base 'Catalyst::Controller';
use File::Basename;
use File::Path;

=head1 NAME

vdc::Controller::_admin_creadores_vida - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->response->body('Matched vdc::Controller::_admin_creadores_vida in _admin_creadores_vida.');
}


sub editar : Local {

    my ($self, $c, $id_creador) = @_;

    my $creador = $c->model('vdcDB::creadores')
	->find({ id => $id_creador });
    $c->stash->{creador} = $creador;
    
    # obtener registro de la vida
    my $vida = undef;
    if(my $vida_id = $creador->vida){
	$vida = $c->model('vdcDB::vida_creador')
	    ->find({ id => $vida_id });
    }

    unless($vida) {
	# crear la vida del creador
	$vida = $c->model('vdcDB::vida_creador')
	    ->create({texto => '',audio => ''});
	$creador->set_columns({vida => $vida->id});
	$creador->update();
    }

    $c->stash->{vida} = $vida;

    
    # si estamos re-entrando ya viene llena
    unless($c->stash->{widget_result}){

	my $w = $self->make_creador_vida_widget($c);

	$w->action($c->uri_for("editar_dale/$id_creador"));
	
	$vida->fill_widget($w);
	$w->get_element(name => 'audio_v')->value($vida->audio);

	$c->stash->{widget_result} = $w->result;
    }


    # opciones comunes
    $c->stash->{opciones} = [
			     {
				 txt => 'Editar Creador',
				 accion => $c->uri_for("/_admin_creadores/editar/$id_creador"),
			     },
			     {
				 txt => 'Menú Principal',
				 accion => $c->uri_for('/_admin_main'),
			     },
			     {
				 txt => 'Lista de Creadores',
				 accion => $c->uri_for('/_admin_creadores'),
			     },
			     ];

    # Asociar la plantilla
    $c->stash->{template} = 'admin/creador_editar.tt2';


}

sub editar_dale : Local {
    my ($self, $c, $id_creador) = @_;

    # para el estado y los errores
    my @status_msgs = ();
    my @error_msgs = ();


    # obtener info del creador
    my $creador = $c->model('vdcDB::creadores')
	->find({ id => $id_creador });
    
    # guardar en el stash
    $c->stash->{creador} = $creador;	

    # obtener registro de la vida
    my $vida = $c->model('vdcDB::vida_creador')
	->find({ id => $creador->vida });

    # guardar en el stash
    $c->stash->{vida} = $creador;	

    # obtener el texto de la vida
    my $texto = $c->request->params->{texto};

    # actualizar bd
    $vida->set_columns({texto => $texto});

    push @status_msgs, 'Se actualizó el texto de la vida';
    
    # si hay que cambiar el audio de la vida
    if ( my $upload = $c->request->upload('audio_nuevo') ) {
	
	# nombre básico del archivo
	my $filename = $upload->filename;


	# ruta 
	my $path = 
	    $c->config->{biblioteca}."/".$c->config->{dir_creadores}."/$id_creador/".
	    $c->config->{audio};
	
	# target
	my $target = $path."/$filename";

	# verificar / crear ruta
	mkpath($path,0,0755) unless stat($path);

	# subir el archivo
	if ( $upload->link_to($target) || $upload->copy_to($target) ) {

	    # nombre del archivo viejo
	    my $org_filename = $c->request->params->{audio} || undef;
	    
	    # subió bien
	    push @status_msgs, "Se copió $filename a $target";

	    # en este punto debemos actualizar la BD

	    $vida->set_columns({audio => $filename});


	    # borrar los anteriores
	    if($org_filename){
		
		$org_filename =~ /(.*)\..*/;
		my $del_str = $path.'/'.$1.'*';
		
		opendir(DIR, $path);
		my @files = grep { /^$1.*$/ } readdir(DIR);
		closedir(DIR);

		foreach my $file (@files){
		    unlink $path.'/'.$file
			or push @error_msgs, "No se pudo borrar el archivo viejo ($file): $!";
		}

		push @status_msgs, "Se borraron los archivos viejos ($del_str)";

	    }


	}
	else {

	    push @error_msgs, "No se pudo copiar $filename a $target : $!";

	}
	
    }

    $vida->update();

    $c->stash->{status_msgs} = \@status_msgs;
    $c->stash->{error_msgs} = \@error_msgs;	
    
    $c->detach('editar', [$id_creador]);

}


sub make_creador_vida_widget : Private {

    my ($self, $c) = @_;
    
    my $w = $c->widget('creador_vida_form')
	->method('post');
    
    $w->element('Hidden', 'audio' );

    $w->element('Textfield', 'audio_v' )->label('Archivo Audio Actual')->size(40)->attrs->{disabled} = 'disabled';

    $w->element('Upload', 'audio_nuevo' )->label('Nuevo Archivo de Audio')->size(40);

    $w->element('Textarea', 'texto' )
	->label('Texto de la Vida')
	->cols(65)
	->rows(40);


    $w->element('Submit', 'submit' )->value('Actualizar BD');


    # Return the widget
    return $w;
    
}




=head1 AUTHOR

Alejandro Imass,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
