package vdc::Controller::buscador;

use strict;
use warnings;
use base 'Catalyst::Controller';

=head1 NAME

vdc::Controller::buscador - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->response->body('Matched vdc::Controller::buscador in buscador.');
}

sub resultado : Local {

    my ( $self, $c ) = @_;
    
    my $criteria = lc($c->request->params->{criteria});     

    # asociar la plantilla 
    $c->stash->{template} = 'buscador/resultado.tt2';
        
    if($criteria eq ''){
	$c->stash->{mensaje} = '¡Debe introducir un criterio en la casilla de búsqueda!';
	$c->forward('end');
    }
    
    
    # buscar todo el material de este tipo
    my $rows = [$c->model('vdcDB::buscador_v1')
		->search({texto => {like => '%'.$criteria.'%'}})];
    
    my @new_rows = ();
    my $i = 0;
    my $ll = $c->config->{buscador_len_ll};
    my $lw = $c->config->{buscador_len_lw};
    foreach my $row (@$rows){
	
	my $new_text = '';
	my $long_text = $row->get_column('texto');
	
	my $ii = 0;
	while($long_text =~ /$criteria/g){
	    my $position = pos($long_text);
	    $new_text .= '...'.substr($long_text,($position-$ll),$lw).'...<br>';
	    $new_text =~ s/$criteria/\<b\>$criteria\<\/b\>/g;
	    $ii++;
	    last if($ii > 2);
	}
	
	$new_rows[$i] = {
	    id => $row->get_column('id'),
	    entidad => $row->get_column('entidad'),
	    sub_entidad => $row->get_column('sub_entidad'),
	    texto => $new_text,
	};
	
	$i++;
	
    }
    
    # buscar categorias en la bd (para el menu)
    $c->stash->{categorias} = [$c->model('vdcDB::categorias')->all];

    $c->stash->{mensaje} = 'Se encontraron '.@new_rows.' registros con: <b>'.$criteria.'</b>';
    
    $c->stash->{resultados} = \@new_rows;

}


sub ir_a : Local {

    my ($self, $c, $sec, $sub_sec, $id) = @_;

    # caso creador: se toma la primera subcat que se encuentre
    if( ($sec eq 'creadores') || ($sec eq 'vida_creador')){

	# referencia al creador
	my $creador = undef;

	# si es la vida, hay que buscar el id del creador
	if($sec eq 'vida_creador'){

	    # buscar sub_cats asociadas a este creador
	    $creador = $c->model('vdcDB::creadores')
		->find({vida => $id});
	    
	    # sustituimos el id por el del creador
	    $id = $creador->get_column('id');
	}
	else{

	    # buscar sub_cats asociadas a este creador
	    $creador = $c->model('vdcDB::creadores')
		->find({id => $id});

	}

	# puede ser un miembro del equipo
	if($creador->spl eq $c->config->{spl_equipo}){

	    $c->detach('/proyecto/equipo', [$id]);
	}

	# buscar sub_cats asociadas a este creador
	my $sub_cat = [$c->model('vdcDB::sub_categorias_creadores')
		       ->search({'id_creador' => $id})];

	# si al menos está asociado a una...
	if(defined $sub_cat->[0]){

	    # se toma la primera...
	    my $sub_categoria = $sub_cat->[0]->get_column('id_sub_categoria');

	    #ver el creador...
	    $c->detach('/creador/ver', [$id, $sub_categoria]);
	}
	# si no, sin mucha explicación vamos al inicio...
	else{
	    #ver el creador...
	    $c->detach('/noticias/ver',[]);
	}



    }

    # caso material: se va al material en cuestión
    if($sec eq 'material'){
	
	# buscar info del material
	my $material = [$c->model('vdcDB::material')
		       ->search({id => $id})];

	my $tipo_mat = $material->[0]->get_column('tipo');
	my $mat_filtro = $material->[0]->get_column('grupo');
	my $id_creador = $material->[0]->get_column('id_creador');


	# buscar sub_cats asociadas a este creador
	my $sub_cat = [$c->model('vdcDB::sub_categorias_creadores')
		       ->search({'id_creador' => $id_creador})];

	# se toma la primera...
	my $sub_categoria = $sub_cat->[0]->get_column('id_sub_categoria');
	

	#ver el material...
	$c->detach('/creador/obra', [$id_creador, $sub_categoria, $tipo_mat, $mat_filtro, $id]);

    }

    # caso notas: se va a la nota. no incluye las institucionales
    if($sec eq 'notas'){

	# buscar sub_cats asociadas a este creador
	my $nota = [$c->model('vdcDB::notas')
		       ->search({id => $id})];

	# se toma la primera...
	my $tipo_nota = $nota->[0]->get_column('tipo');
	
	if($tipo_nota eq $c->config->{noticias}){
	    $c->detach('/noticias/ver', [$id])
	}

	if($tipo_nota eq $c->config->{proyecto}){
	    $c->detach('/proyecto/info', [$id])
	}
    
    }

}


sub end : ActionClass('RenderView') {


}


=head1 AUTHOR

Alejandro Imass,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
