package vdc::Controller::catalogo;

use strict;
use warnings;
use base 'Catalyst::Controller';

=head1 NAME

vdc::Controller::catalogo - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->response->body('Matched vdc::Controller::catalogo in catalogo.');
}

sub subcat : Local {

    # parámetros comunes
    my ($self, $c, $categoria) = @_;

    # categoria actual (solo el id)
    $c->stash->{cat_actual} = $categoria;

    # buscar categorias en la bd (para el menu)
    $c->stash->{categorias} = [$c->model('vdcDB::categorias')->all];

    # buscar sub-categorias en la bd
    $c->stash->{sub_categorias_v1} = [$c->model('vdcDB::sub_categorias_v1')
				   ->search({ id_categoria => $categoria })];

    # buscar nota institucional 1
    $c->stash->{nota_ins} = [$c->model('vdcDB::notas')
			     ->search(
				      { 
					  'tipo_nota.id' => $c->config->{nota_ins_1},
				      },
				      {
					  join => [qw/ tipo_nota /],
					  prefetch => [qw/ tipo_nota /],
				      }
				      )
			     ];
    
    # asociar la plantilla
    $c->stash->{template} = 'catalogo/ver_subcat.tt2';


}

sub creadores : Local {

    # parámetros comunes
    my ($self, $c, $sub_categoria, $creador) = @_;

    # sub_categoria actual (el registro completo)
    my $sub_cat_actual = $c->model('vdcDB::sub_categorias')
	->find({ id => $sub_categoria });
    $c->stash->{sub_cat_actual} = $sub_cat_actual;

    # sub_categoria actual (el registro completo)
    $c->stash->{cat_actual} = $c->model('vdcDB::categorias')
	->find({ id => $sub_cat_actual->id_categoria });

    # buscar categorias en la bd (para el menu)
    $c->stash->{categorias} = [$c->model('vdcDB::categorias')->all];

    # buscar autores en la bd
    $c->stash->{creadores} = [$c->model('vdcDB::creadores')
				   ->search(
					    { 
						'sub_categorias_creadores.id_sub_categoria' => $sub_categoria,
					    },
					    {
						join => [qw/ sub_categorias_creadores /],
						prefetch => [qw/ sub_categorias_creadores /],
					    }
					    )
			      ];

    # si se ha seleccionado un autor entonces mostrar sinopsis
    if(defined($creador)){

	# el registro completo del autor
	$c->stash->{creador_actual} = [$c->model('vdcDB::creadores')
				   ->search({ id => $creador })];

	#conteo de material por autor
	$c->stash->{material_autor} = [$c->model('vdcDB::material_creador_v1')
				   ->search({ id_creador => $creador })];


    }
    # si no, se muestra la noticia institucional
    else {
	# buscar nota institucional 2
	$c->stash->{nota_ins} = [$c->model('vdcDB::notas')
				 ->search(
					  { 
					      'tipo_nota.id' => $c->config->{nota_ins_2},
					  },
					  {
					      join => [qw/ tipo_nota /],
					      prefetch => [qw/ tipo_nota /],
					  }
					  )
				 ];

    }

    # asociar la plantilla
    $c->stash->{template} = 'catalogo/ver_creadores.tt2';

}



=head1 AUTHOR

Alejandro Imass,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
