package vdc::Controller::creador;

use strict;
use warnings;
use base 'Catalyst::Controller';

=head1 NAME

vdc::Controller::creador - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->response->body('Matched vdc::Controller::creador in creador.');
}


sub ver : Local {

    # parámetros comunes
    my ($self, $c, $creador, $sub_categoria) = @_;


    # obtener detalles de la sub_cat de donde encontraron a este creador
    $c->stash->{sub_cat} = [$c->model('vdcDB::sub_categorias_creadores')
				   ->search(
					    { 
						'id_creador' => $creador,
						'id_sub_categoria' => $sub_categoria,
					    },
					    {
						join => [qw/ sub_categorias /],
						prefetch => [qw/ sub_categorias /],
					    }
					    )
			      ];


    # esto es temporal; hay que ver si ya el contexto tiene este dato
    $c->stash->{player} = 'on';
    

    # buscar categorias en la bd (para el menu)
    $c->stash->{categorias} = [$c->model('vdcDB::categorias')->all];


    # el registro completo del autor
    $c->stash->{creador} = [$c->model('vdcDB::creadores')
			    ->search({ id => $creador })];

    # tipos de material por autor
    $c->stash->{tipos_mat_creador} = [$c->model('vdcDB::tipos_mat_creador_v1')
				      ->search({ id_creador => $creador })];

    # asociar la plantilla
    $c->stash->{template} = 'creador/ver.tt2';

}

sub obra : Local {

    # parámetros comunes
    my ($self, $c, $creador, $sub_categoria, $tipo_mat, $mat_filtro, $mat_id) = @_;

    # obtener detalles de la sub_cat de donde encontraron a este creador
    $c->stash->{sub_cat} = [$c->model('vdcDB::sub_categorias_creadores')
				   ->search(
					    { 
						'id_creador' => $creador,
						'id_sub_categoria' => $sub_categoria,
					    },
					    {
						join => [qw/ sub_categorias /],
						prefetch => [qw/ sub_categorias /],
					    }
					    )
			      ];

    # el registro completo del autor
    $c->stash->{creador} = [$c->model('vdcDB::creadores')
			    ->search({ id => $creador })];

    # tipos de material por autor
    $c->stash->{tipos_mat_creador} = [$c->model('vdcDB::tipos_mat_creador_v1')
				      ->search({ id_creador => $creador })];
    # tipo de material seleccionado
    $c->stash->{tipo_mat_actual} = $tipo_mat;

    # tipo de material seleccionado
    $c->stash->{mat_id} = defined($mat_id) ? $mat_id : 0;

    # tipos de material por autor
#     $c->stash->{filtros_mat_creador} = [$c->model('vdcDB::filtros_mat_creador_v1')
# 				      ->search(
# 					       { 
# 						   id_creador => $creador,
# 						   tipo_material_id => $tipo_mat,
# 					       }
# 					       )
# 					];

    my $filtros = [$c->model('vdcDB::filtros_mat_creador_v1')
		  ->search(
			   { 
			       id_creador => $creador,
			       tipo_material_id => $tipo_mat,
			   }
			   )
		  ];
    
    $c->stash->{filtros_mat_creador} = $filtros;

    # tipo de material seleccionado

    $mat_filtro = defined($mat_filtro) ? $mat_filtro : $filtros->[0]->get_column('filtro');

    $c->stash->{mat_filtro} = $mat_filtro;

    # buscar categorias en la bd (para el menu)
    $c->stash->{categorias} = [$c->model('vdcDB::categorias')->all];


    # buscar todo el material de este tipo
    $c->stash->{material} = [$c->model('vdcDB::material')
			     ->search({
				 id_creador => $creador,
				 grupo => $mat_filtro,
			     }
				      )];


    # asociar la plantilla según el tipo de material (ver conf (vdc.yml))
    $c->stash->{template} = 'creador/'.$c->config->{tipo_mat_tt}{$tipo_mat}.'.tt2';

}

sub end : ActionClass('RenderView') {


}


=head1 AUTHOR

Alejandro Imass,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
