package vdc::Controller::noticias;

use strict;
use warnings;
use base 'Catalyst::Controller';

=head1 NAME

vdc::Controller::noticias - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->response->body('Matched vdc::Controller::noticias in noticias.');
}

sub ver : Local {
    
    # parámetros comunes
    my ($self, $c, $nota, $modifier) = @_;
    
    # reset modifier
    if($modifier){
	# pueden haber mas casos en el futuro (aparte de infantil)
	if($modifier eq 'infantil'){
	    $c->stash->{page_name} = 'infantil';
	}
    }

    # buscar noticias en la bd

    my $search_c = ();

    if($c->stash->{page_name}){
	# pueden haber mas casos en el futuro (aparte de infantil)
	if($c->stash->{page_name} eq 'infantil'){
	    $search_c->{tipo} = $c->config->{infantil};
	}
    }
    else {
	$search_c->{tipo} = $c->config->{noticias};
    }


    my $notas = [$c->model('vdcDB::notas')
		 ->search($search_c)];

    $c->stash->{notas} = $notas; 

    # ver nota num
    $c->stash->{nota} = (defined $nota) ? $nota : 0;


    # buscar categorias en la bd (para el menu)
    $c->stash->{categorias} = [$c->model('vdcDB::categorias')->all];
    
    # asociar la plantilla
    $c->stash->{template} = 'noticias/ver.tt2';
}


=head1 AUTHOR

Alejandro Imass,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
