package vdc::Controller::proyecto;

use strict;
use warnings;
use base 'Catalyst::Controller';

=head1 NAME

vdc::Controller::proyecto - Catalyst Controller

=head1 DESCRIPTION

Catalyst Controller.

=head1 METHODS

=cut


=head2 index 

=cut

sub index : Private {
    my ( $self, $c ) = @_;

    $c->response->body('Matched vdc::Controller::proyecto in proyecto.');
}

sub info : Local {
    
    # parámetros comunes
    my ($self, $c, $nota) = @_;
    

    # buscar noticias en la bd

    my $notas = [$c->model('vdcDB::notas')
		 ->search({tipo => $c->config->{proyecto}})];

    $c->stash->{notas} = $notas; 

    # ver nota num
    $c->stash->{nota} = (defined $nota) ? $nota : 0;

    # buscar categorias en la bd (para el menu)
    $c->stash->{categorias} = [$c->model('vdcDB::categorias')->all];
    
    # asociar la plantilla
    $c->stash->{template} = 'proyecto/info.tt2';
}

sub contacto : Local {
    
    # parámetros comunes
    my ($self, $c) = @_;

    $c->stash->{titulo} = $c->config->{contacto}{titulo};
    $c->stash->{head} = $c->config->{contacto}{head};
    $c->stash->{direc} = $c->config->{contacto}{direc};
    $c->stash->{tlf} = $c->config->{contacto}{tlf};

    # buscar categorias en la bd (para el menu)
    $c->stash->{categorias} = [$c->model('vdcDB::categorias')->all];

    # asociar la plantilla
    $c->stash->{template} = 'proyecto/contacto.tt2';
        
}

sub equipo : Local {

    # parámetros comunes
    my ($self, $c, $integrante) = @_;


    # buscar categorias en la bd (para el menu)
    $c->stash->{categorias} = [$c->model('vdcDB::categorias')->all];

    # buscar autores en la bd
    $c->stash->{equipo} = [$c->model('vdcDB::creadores')
				   ->search({spl => $c->config->{spl_equipo}})];

    # si se ha seleccionado un autor entonces mostrar sinopsis
    if(defined($integrante)){

	# el registro completo del autor
	$c->stash->{integrante_actual} = [$c->model('vdcDB::creadores')
				   ->search({ id => $integrante })];

    }
    # si no, se muestra la noticia institucional
    else {
	# buscar nota institucional 2
	$c->stash->{nota_ins} = [$c->model('vdcDB::notas')
				 ->search(
					  { 
					      'tipo_nota.id' => $c->config->{nota_ins_2},
					  },
					  {
					      join => [qw/ tipo_nota /],
					      prefetch => [qw/ tipo_nota /],
					  }
					  )
				 ];

    }

    # asociar la plantilla
    $c->stash->{template} = 'proyecto/ver_equipo.tt2';

}



=head1 AUTHOR

Alejandro Imass,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;
