package vdc::View::TT;

use strict;
use base 'Catalyst::View::TT';

__PACKAGE__->config({
    CATALYST_VAR => 'Catalyst',
    INCLUDE_PATH => [
        vdc->path_to( 'root', 'src' ),
        vdc->path_to( 'root', 'lib' ),
        vdc->path_to( 'root', 'static' ),
    ],
    PRE_PROCESS  => 'config/main',
    WRAPPER      => 'site/wrapper',
    ERROR        => 'error.tt2',
    TIMER        => 0
});

=head1 NAME

vdc::View::TT - Catalyst TTSite View

=head1 SYNOPSIS

See L<vdc>

=head1 DESCRIPTION

Catalyst TTSite View.

=head1 AUTHOR

Alejandro Imass,,,

=head1 LICENSE

This library is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

1;

