package vdcDB::creadores;

use base qw/DBIx::Class/;

# Cosas requeridas de DBIC
__PACKAGE__->load_components(qw/PK::Auto Core HTMLWidget/);
# Nombre de la tabla
__PACKAGE__->table('creadores');
# Columnas de la tabla
__PACKAGE__->add_columns(qw/
			 id                  
			 nombre1             
			 nombre2             
			 apellido1           
			 apellido2           
			 fecha_nacimiento    
			 fecha_muerte        
			 sinopsis_imagen     
			 sinopsis_texto      
			 sintesis_curricular 
			 imagen_principal    
			 vida                
			 spl                 
			 /);



# Clave primaria
__PACKAGE__->set_primary_key(qw/id/);

# Relación 1..n con sub-categorías
__PACKAGE__->has_many(sub_categorias_creadores => 'vdcDB::sub_categorias_creadores', 'id_creador');

# Relación 1..n con material
__PACKAGE__->has_many(material => 'vdcDB::material', 'id_creador');

# relación clave foránea con tipo_nota
__PACKAGE__->belongs_to(vida_creador => vdcDB::vida_creador, 'vida');

1;
