package vdcDB::material;

use base qw/DBIx::Class/;

# Cosas requeridas de DBIC
__PACKAGE__->load_components(qw/PK::Auto Core HTMLWidget/);
# Nombre de la tabla
__PACKAGE__->table('material');
# Columnas de la tabla
__PACKAGE__->add_columns(qw/
			 id         
			 id_creador 
			 tipo       
			 clase      
			 grupo      
			 archivo    
			 titulo     
			 tecnica    
			 dimensiones
			 fecha_obra 
			 nota1      
			 nota2      
			 nota3      
			 /);


# Clave primaria
__PACKAGE__->set_primary_key(qw/id/);

# relación clave foránea con tipo_material
__PACKAGE__->belongs_to(tipo_material => vdcDB::tipo_material, 'tipo');

# relación clave foránea con tipo_material
__PACKAGE__->belongs_to(clase_material => vdcDB::clase_material, 'tipo');

# relación clave foránea con creadores
__PACKAGE__->belongs_to(creadores => vdcDB::creadores, 'id_creador');


1;
