package vdcDB::sub_categorias;

use base qw/DBIx::Class/;

# Cosas requeridas de DBIC
__PACKAGE__->load_components(qw/PK::Auto Core/);
# Nombre de la tabla
__PACKAGE__->table('sub_categorias');
# Columnas de la tabla
__PACKAGE__->add_columns(qw/
			 id
			 id_categoria
			 nombre
			 descripcion
			 /);

# Clave primaria
__PACKAGE__->set_primary_key(qw/id/);

# relación clave foránea con categorías
__PACKAGE__->belongs_to(categorias => vdcDB::categorias, 'id_categoria');

# Relación 1..n con sub_categorias_creadores
__PACKAGE__->has_many(sub_categorias_creadores => 'vdcDB::sub_categorias_creadores', 'id_sub_categoria');


1;
