package vdcDB::sub_categorias_creadores;

use base qw/DBIx::Class/;

# Cosas requeridas de DBIC
__PACKAGE__->load_components(qw/PK::Auto Core/);
# Nombre de la tabla
__PACKAGE__->table('sub_categorias_creadores');
# Columnas de la tabla
__PACKAGE__->add_columns(qw/
			 id_creador
			 id_sub_categoria
			 especializacion
			 /);

# Clave primaria
__PACKAGE__->set_primary_key(qw/id_creador id_sub_categoria/);

# relación clave foránea con creadores
__PACKAGE__->belongs_to(creadores => vdcDB::creadores, 'id_creador');

# relación clave foránea con sub_categorias
__PACKAGE__->belongs_to(sub_categorias => vdcDB::sub_categorias, 'id_sub_categoria');

1;
