package vdcDB::usuarios;

use base qw/DBIx::Class/;

# Cosas requeridas de DBIC
__PACKAGE__->load_components(qw/PK::Auto Core/);
# Nombre de la tabla
__PACKAGE__->table('usuarios');
# Columnas de la tabla
__PACKAGE__->add_columns(qw/
			 id
			 usuario
			 cedula
			 clave
			 email
			 nombre
			 apellido
			 activo
			 /);

# Clave primaria
__PACKAGE__->set_primary_key(qw/id/);

# Relación 1..n con roles_usuario
__PACKAGE__->has_many(roles_usuarios => 'vdcDB::roles_usuarios', 'id_usuario');


1;
