#!/bin/bash

#replace with your own crushtool binary
crushtool=~/git-checkouts/ceph3/src/crushtool

for i in *.straw; do
	cat $i | sed 's/straw/straw2/g' | grep -v 'straw2_calc_version' > /tmp/$i.2
	$crushtool -c $i -o /tmp/$i.in
	$crushtool -c /tmp/$i.2 -o /tmp/$i.in.2
	$crushtool --min-x 0 --max-x 10000 --num-rep 1 -i /tmp/$i.in --test --show-mappings > /tmp/$i.2.mappings
	$crushtool --min-x 0 --max-x 10000 --num-rep 1 -i /tmp/$i.in.2 --test --show-mappings > /tmp/$i.mappings
	diff -y --suppress-common-lines /tmp/$i.mappings /tmp/$i.2.mappings > /tmp/$i.diff
done
