<cfcomponent displayname="abstract" output="false" extends="Root">

	<cfproperty name="constants" type="string" displayname="read-only"
		required="false" default="priavtely defined"
		hint="a list of structure keys (from the variables structure) that are
		to be ignored during the getMemento() method." />
	<cfproperty name="constantFunctions" type="string" displayname="read-only"
		required="false" default="priavtely defined"
		hint="a list of struct keys (from the this structure) that are to be
		ignored during the getFunctions() method." />
	<cfproperty name="errors" type="array" displayname="private"
		required="false" default="arrayNew(1)"
		hint="the errors array. used for passing errors from the model to the
		frontend." />
	<cfproperty name="messages" type="array" displayname="private"
		required="false" default="arrayNew(1)"
		hint="the messages array. used for passing warnings and general
		information from the model to the frontend." />

	<cfset variables.constants = 'constants,this,constantfunctions,' &
			'null,enodata' /> <!-- these are all lowercase --->
	<cfset variables.constantFunctions = 'init,getMemento,setMemento,' &
			'getContents,getErrors,setErrors,clearErrors,getConstants,' &
			'getConstantFunctions,getFunctions,getMemos,setMemos' />

	<cffunction name="init" access="public" returntype="any" output="false"
		hint="clears the errors and messages structures. should be called by
		every object that extends this object.">
		<cfset clearErrors() />
		<cfset clearMessages() />
		<cfreturn this />
 	</cffunction>
	
	<!--- UTILITIES --->
	
	<!-----------------------------------------------------------------------------------
		getMemento
	------------------------------------------------------------------------------------>
	<cffunction name="getMemento" access="public" returntype="struct" output="false"
		hint="returns a struct of the data stored in the variables scope, with
		the constant values (created by this object) removed.">
		<cfset var values = structNew() />
		<cfset var i = 0 />

		<cfloop item="i" collection="#variables#">
			<cfif not isCustomFunction( variables[i] ) and
				not listfind( variables.constants, lcase( i ) )>
				<cfset values[i] = variables[i] />
			</cfif>
		</cfloop>
		
		<cfreturn values />
	</cffunction>
	
	<!-----------------------------------------------------------------------------------
		setMemento
	------------------------------------------------------------------------------------>
	<cffunction name="setMemento" access="public" returntype="void"
		hint="not ready yet. this should (in the end) be used as a copy
		constructor. but there are problems when trying to duplicate
		components in components.">
		<cfargument name="memento" type="struct" required="yes" />
		
		<cfset var values = structNew() />
		<cfset var i = 0 />
		
		<cfloop item="i" collection="#arguments.memento#">
			<cfif isSimpleValue( arguments.memento[i] )>
				<cfset values[i] = arguments.memento[i] />
			<cfelseif isObject( arguments.memento[i] )>
				<!---
					TODO:
					
					Create a duplicate of the object to be copied.
					The duplicate() method cannot be used.
					You can get the type of the object by using
					getMetaData( arguments.memento[i] ).name.
					The hard part is creating replicas of the
					information inside the object (making
					a cascading effect). I really wish Coldfusion
					allowed for overloaded functions.
				--->
				<cfset values[i] = arguments.memento[i] />
			<cfelse>
				<cfset values[i] = duplicate( arguments.memento[i] ) />
			</cfif>
		</cfloop>
		
		<cfset init( argumentcollection = arguments.memento ) />
	</cffunction>
	
	<!-----------------------------------------------------------------------------------
		getFunctions
	------------------------------------------------------------------------------------>
	<cffunction name="getFunctions" access="public" returntype="struct" output="false"
		hint="returns a struct of the functions, not included the functions created
		by this object.">
		<cfset var image = structNew() />
		<cfset var functions = getMetaData( this ).functions />
		<cfset var name = 0 />
		<cfset var i = 0 />
		
		<cfloop index="i" from="1" to="#arraylen(functions)#">
			<cfset name = functions[i].name />
			<cfif not listFind( variables.constantFunctions, name )>
				<cfset image[name] = variables[name] />
			</cfif>
		</cfloop>
		
		<cfreturn image />
	</cffunction>
	
	<!-----------------------------------------------------------------------------------
		getContents
	------------------------------------------------------------------------------------>
	<cffunction name="getContents" access="public" returntype="struct" output="false"
		hint="returns a struct of the values from getFunctions() and getMemento().">
		<cfset var contents = getFunctions() />
		<cfset structAppend( contents, getMemento() ) />
		<cfreturn contents />
	</cffunction>
	
	<!--- ERRORS / MESSAGES --->
	
	<cffunction name="getErrors" access="public" returntype="array" output="false">
		<cfreturn variables.errors />
	</cffunction>
	<cffunction name="setErrors" access="public" returntype="void" output="false">
		<cfargument name="errors" type="array" required="yes" />
		<cfset variables.errors = arguments.errors />
	</cffunction>
	<cffunction name="addError" access="public" returntype="void" output="false">
		<cfargument name="error" type="string" required="yes" />
		<cfset arrayAppend( variables.errors, arguments.error ) />
	</cffunction>
	<cffunction name="clearErrors" access="public" returntype="void" output="false">
		<cfset variables.errors = arrayNew(1) />
	</cffunction>
	
	<cffunction name="getMessages" access="public" output="false" returntype="array">
		<cfreturn variables.messages />
	</cffunction>
	<cffunction name="setMessages" access="public" output="false" returntype="void">
		<cfargument name="messages" required="yes" type="array" />
		<cfset variables.messages = arguments.messages />
	</cffunction>
	<cffunction name="addMessage" access="public" output="false" returntype="void">
		<cfargument name="msg" required="yes" type="string" />
		<cfset arrayAppend( variables.messages, arguments.msg ) />
	</cffunction>
	<cffunction name="clearMessages" access="public" output="false" returntype="void">
		<cfset variables.messages = arrayNew(1) />
	</cffunction>
	
	
	<cffunction name="getMemos" access="public" output="false" returntype="struct"
		hint="Mostly used in DAO's to store messages/errors that would normally
			be erased by init() calls">
		<cfscript>
			var memos = structNew();
			memos.messages = duplicate( variables.messages );
			memos.errors = duplicate( variables.errors );
			return memos;
		</cfscript>
	</cffunction>
	<cffunction name="setMemos" access="public" output="false" returntype="void"
		hint="Mostly used in DAO's to store messages/errors that would normally
			be erased by init() calls">
		<cfargument name="memos" type="struct" required="yes" />
		<cfscript>
			if( structKeyExists( memos, 'messages' ) )
				variables.messages = memos.messages;
			if( structKeyExists( memos, 'errors' ) )
				variables.errors = memos.errors;
		</cfscript>
	</cffunction>
		
	<!--- GETTERS/SETTERS --->
	
	<cffunction name="getConstants" access="public" returntype="string" output="false">
		<cfreturn variables.constants />
	</cffunction>
	<cffunction name="getConstantFunctions" access="public" returntype="string" output="false">
		<cfreturn variables.constantFunctions />
	</cffunction>
	
	
	<!--- VALIDATE --->
	
	<cffunction name="validate" access="public" returntype="boolean" output="false"
		displayname="Validate" hint="abstract. just in case you forget to create
		this method	in the object that extends this base object.">
		<cfscript>
			var errors = structNew();

			
			// This method should be overwritten and the new code placed here.
			// error messages should take the place of normal comments
			
			if( arraylen(variables.errors) ) {
					setErrors( errors );
					return false;
				}
			return true;
		</cfscript>		
	</cffunction>
	
</cfcomponent>
