<cfcomponent displayname="listener" output="false" extends="ScriptListener">

	<cffunction name="configure" access="public" returntype="void" output="false">
		<cfscript>
			variables.bcFacade = createObject('component','BeanCreatorFacade').init();
		</cfscript>
	</cffunction>
	
	<cffunction name="generate" access="public" returntype="void" output="false"
		hint="Bootstrap between Mach-II and bean creator model.<br /><br />
		Requires:<br />
		Event object must have beanCreator as argument.<br /><br />
		Returns:<br />
		Places complete beanCreator into Event object.">
		<cfargument name="event" type="MachII.framework.Event" required="yes" />
		<cfscript>
			var bc = arguments.event.getArg( 'beanCreator' );
			var e = 0;
			
			try {
				bc = variables.bcFacade.createAll( bc );
			} catch( EINPUT e ) {
				bc.addError( e );
			} catch( EPARSED e ) {
				bc.addError( e );
			}
			
			arguments.event.setArg( 'beanCreator', bc );
		</cfscript>
	</cffunction>
	
</cfcomponent>