<cfcomponent displayname="abstract" output="false" extends="Root">

	<cfproperty name="CR" displayname="private" required="true"
		type="string" default="chr(13) & chr(10)"
		hint="shortcut for Carriage Return and New Line Feed" />
	
	<cfproperty name="TAB" displayname="private" required="true"
		type="string" default="chr(9)"
		hint="shortcut for Tab" />
		
	<cfproperty name="SP" displayname="private" required="true"
		type="string" default="chr(32)"
		hint="shortcut for Space" />
		
	<cfproperty name="defaults" displayname="private" required="true"
		type="struct" default=""
		hint="contains the default value for different variable types" />
		
	
	<!-------------------------------------------------------------->
	
	
	<cffunction name="init" access="public" output="false"
		returntype="CommonValues">
		<cfscript>
			/*
				NOTE:
					Even though I am defining these variables appropriately
				in the 'variables' scope. But, I will not be scoping the
				variables upon usage.
			*/
			
			// setup some constant variables
			variables.CR = chr(13) & chr(10);
			variables.TAB = chr(9);
			variables.SP = chr(32);
			
			// setup the defaults structure
			// (cannot place object in here because it is dynamic)
			variables.defaults = structNew();
			variables.defaults.string = '';
			variables.defaults.boolean = 'false';
			variables.defaults.numeric = '0';
			variables.defaults.struct = '##structNew()##';
			variables.defaults.array = '##arrayNew(1)##';
			variables.defaults.query = "##querynew('')##";
			
			// return object
			return this;
		</cfscript>
	</cffunction>
	
	
	<!-------------------------------------------------------------->
	
	
	<!---------------------------------------------------------------
		uCaseFirstLetter
	---------------------------------------------------------------->
	<cffunction name="uCaseFirstLetter" access="private" output="false"
		returntype="string"
		hint="forces the first letter of the string to uppercase">
		<cfargument name="nString" type="string" required="yes" />
		<cfscript>
			var cname = '';
			var slen = len(arguments.nString);
			
			if( not slen ) return cname;
			
			if( slen gt 1 )
				cname = ucase( left( arguments.nString, 1 ) ) &
					right( arguments.nString, slen - 1 );
			else
				cname = ucase( arguments.nString );
				
			return cname;
		</cfscript>
	</cffunction>
	
	<!---------------------------------------------------------------
		lCaseFirstLetter
	---------------------------------------------------------------->
	<cffunction name="lCaseFirstLetter" access="private" output="false"
		returntype="string"
		hint="forces the first letter of the string to lowercase">
		<cfargument name="nString" type="string" required="yes" />
		<cfscript>
			var cname = '';
			var slen = len(arguments.nString);
			
			if( not slen ) return cname;
			
			if( slen gt 1 )
				cname = lcase( left( arguments.nString, 1 ) ) &
					right( arguments.nString, slen - 1 );
			else
				cname = lcase( arguments.nString );
				
			return cname;
		</cfscript>
	</cffunction>
	
</cfcomponent>
