<cfcomponent displayname="abstract" output="false" extends="CommonValues">

	<cffunction name="init" access="public" output="false" returntype="Service">
		<cfscript>
			super.init();
			return this;
		</cfscript>
	</cffunction>
	
	
	<!-------------------------------------------------------------->
	
	
	<cffunction name="newLine" access="private" returntype="string" output="false"
		hint="Adds the appropriate tabs the the front of the string.<br /><br />
		Requires:<br /><br />
		Returns:<br />
		The string with &lt;tabAmount&gt; tags in front of it.">
		<cfargument name="aString" type="string" required="yes" />
		<cfargument name="tabAmount" type="numeric" required="yes" />
		
		<cfscript>
			// setup variables
			var i = 1;
			var o = '';
						
			// increment for tabs
			for( ; i lte tabAmount; i = i + 1 )
				o = o & TAB;
			
			// add the line
			o = o & arguments.aString & CR;
			
			// return the string
			return o;
		</cfscript>
	</cffunction>
	
	<cffunction name="addEmptyLine" access="private" returntype="string" output="false"
		hint="Adds an empty line to the end of a string. If count is specified
		then a &lt;count&gt; number of empty lines are added.<br /><br />
		Requires:<br /><br />
		Returns:<br />
		The string with the empty line appended.">
		<cfargument name="oString" type="string" required="yes" />
		<cfargument name="count" type="numeric" default="1" hint="the number of lines to add" />
		<cfscript>
			var i = 1;
			for( ; i lte arguments.count; i = i + 1 )
				arguments.oString = arguments.oString & CR;
			return arguments.oString;
		</cfscript>
	</cffunction>
	
</cfcomponent>
