<cfcomponent output="false"	extends="edu.ucsb.graddiv.common.base.TestCase">

	<!--- CONSTANTS --->
	<cfscript>
		bcf = newObject( 'edu.ucsb.graddiv.beanCreator.model.BeanCreatorFacade' ).init();
		input = 'Test#chr(13)##chr(10)#t2';
	</cfscript>
	
	<!--- BUILT-IN METHODS --->
	
	<cffunction name="setup" access="public" output="false" returntype="void">
		<cfscript>
			bc = newObject( 'edu.ucsb.graddiv.beanCreator.model.BeanCreator' ).init();
			bc.setInput( input );
		</cfscript>
	</cffunction>
	
	<cffunction name="teardown" access="public" output="false" returntype="void">
		<cfscript>
			bc = 0;
		</cfscript>
	</cffunction>
	
	<!--- TESTS --->
	
	<cffunction name="testCreateAll" access="public" output="false" returntype="void">
		<cfscript>
			bc = bcf.createAll( bc );
			
			assertTrue( len(bc.getBean()) );
			assertTrue( len(bc.getDao()) );
			assertTrue( len(bc.getTestCase()) );
		</cfscript>
	</cffunction>
	
	<cffunction name="testParseInput" access="public" output="false" returntype="void">
		<cfscript>
			var e = 0;
			var parsed = 0;
			
			try {
				parsed = bcf.parseInput( input );
			} catch( EINPUT e ) {
				fail( e );
			}
			
			try {
				parsed = bcf.parseInput( '' );
				fail( 'Did not throw error for invalid input' );
			} catch( EINPUT e ) {
			}
		</cfscript>
	</cffunction>
	
	<cffunction name="testCreateBean" access="public" output="false" returntype="void">
		<cfscript>
			var e = 0;
			var parsed = 0;
			var r = 0;
			
			try {
				parsed = bcf.parseInput( bc.getInput() );
				r = bcf.createBean( parsed, bc.getBeanExtends() );
			} catch( EINPUT e ) {
				fail( 'EINPUT: ' & e );
			} catch( EPARSED e ) {
				fail( 'EPARSED: ' & e );
			}
			
			try {
				parsed = structNew();
				r = bcf.createBean( parsed, '' );
				fail( 'did not throw parsed object error' );
			} catch( EPARSED e ) {
			}
		</cfscript>
	</cffunction>
	
	<cffunction name="testCreateDAO" access="public" output="false" returntype="void">
		<cfscript>
			var e = 0;
			var parsed = 0;
			var r = 0;
			
			try {
				parsed = bcf.parseInput( bc.getInput() );
				r = bcf.createDao( parsed, bc.getBeanExtends() );
			} catch( EINPUT e ) {
				fail( 'EINPUT: ' & e );
			} catch( EPARSED e ) {
				fail( 'EPARSED: ' & e );
			}
			
			try {
				parsed = structNew();
				r = bcf.createDao( parsed, '' );
				fail( 'did not throw parsed object error' );
			} catch( EPARSED e ) {
			}
		</cfscript>
	</cffunction>
	
	<cffunction name="testCreateTestCase" access="public" output="false" returntype="void">
		<cfscript>
			var e = 0;
			var parsed = 0;
			var r = 0;
			
			try {
				parsed = bcf.parseInput( bc.getInput() );
				r = bcf.createTestCase( parsed, bc.getBeanExtends() );
			} catch( EINPUT e ) {
				fail( 'EINPUT: ' & e );
			} catch( EPARSED e ) {
				fail( 'EPARSED: ' & e );
			}
			
			try {
				parsed = structNew();
				r = bcf.createTestCase( parsed, '' );
				fail( 'did not throw parsed object error' );
			} catch( EPARSED e ) {
			}
		</cfscript>
	</cffunction>
	
</cfcomponent>
