<cfcomponent output="false"	extends="edu.ucsb.graddiv.common.base.TestCase">

	<!--- CONSTANTS --->
	<cfscript>
		bcl = newObject( 'edu.ucsb.graddiv.beanCreator.model.BeanCreatorListener' );
		bcl.configure();
		input = 'Test#chr(13)##chr(10)#t2';
	</cfscript>
	
	<!--- BUILT-IN METHODS --->
	
	<cffunction name="setup" access="public" output="false" returntype="void">
		<cfscript>
			bc = newObject( 'edu.ucsb.graddiv.beanCreator.model.BeanCreator' ).init();
			bc.setInput( input );
		</cfscript>
	</cffunction>
	
	<cffunction name="teardown" access="public" output="false" returntype="void">
		<cfscript>
			bc = 0;
		</cfscript>
	</cffunction>
	
	<!--- TESTS --->
	
	<cffunction name="testGenerate" access="public" output="false" returntype="void">
		<cfscript>
			var event = newObject( 'MachII.framework.Event' );

			event.setArg( 'beanCreator', bc );
			bcl.generate( event );
			bc = event.getArg( 'beanCreator' );
			assertBean( bc );
			
			bc.setInput('');
			event.setArg( 'beanCreator', bc );
			bcl.generate( event );
			bc = event.getArg( 'beanCreator' );
			if( not arraylen(bc.getErrors()) )
				fail( 'no errors returned when given invalid input' );
		</cfscript>
	</cffunction>
	
</cfcomponent>
