<cfcomponent displayname="test case" output="false"
	extends="edu.ucsb.graddiv.common.base.TestCase">

	<cfscript>
	</cfscript>


	<!--- BUILT-IN METHODS --->

	<cffunction name="setup" access="public" output="false" returntype="void">
		<cfscript>
			bean = newObject( 'edu.ucsb.graddiv.beanCreator.model.BeanCreator' );
		</cfscript>
	</cffunction>

	<cffunction name="teardown" access="public" output="false" returntype="void">
		<cfscript>
			bean = 0;
		</cfscript>
	</cffunction>


	<!--- TESTS --->

	<cffunction name="testInit" access="public" output="false" returntype="void">
		<cfscript>
			var e = 0;

			try {
				bean.init();
			} catch ( Any e ) {
				fail( e );
			}
		</cfscript>
	</cffunction>

	<cffunction name="testInput" access="public" output="false" returntype="void">
		<cfscript>
			var testValue = 'test string';
			bean.setInput( testValue );
			assertEqualsString( testValue, bean.getInput(),
				"Not equal. Returned '#bean.getInput()#'. Expected 'test string'." );
		</cfscript>
	</cffunction>

	<cffunction name="testBean" access="public" output="false" returntype="void">
		<cfscript>
			var testValue = 'test string';
			bean.setBean( testValue );
			assertEqualsString( testValue, bean.getBean(),
				"Not equal. Returned '#bean.getBean()#'. Expected 'test string'." );
		</cfscript>
	</cffunction>

	<cffunction name="testBeanExtends" access="public" output="false" returntype="void">
		<cfscript>
			var testValue = 'test string';
			bean.setBeanExtends( testValue );
			assertEqualsString( testValue, bean.getBeanExtends(),
				"Not equal. Returned '#bean.getBeanExtends()#'. Expected 'test string'." );
		</cfscript>
	</cffunction>

	<cffunction name="testDao" access="public" output="false" returntype="void">
		<cfscript>
			var testValue = 'test string';
			bean.setDao( testValue );
			assertEqualsString( testValue, bean.getDao(),
				"Not equal. Returned '#bean.getDao()#'. Expected 'test string'." );
		</cfscript>
	</cffunction>

	<cffunction name="testDaoExtends" access="public" output="false" returntype="void">
		<cfscript>
			var testValue = 'test string';
			bean.setDaoExtends( testValue );
			assertEqualsString( testValue, bean.getDaoExtends(),
				"Not equal. Returned '#bean.getDaoExtends()#'. Expected 'test string'." );
		</cfscript>
	</cffunction>

	<cffunction name="testTestCase" access="public" output="false" returntype="void">
		<cfscript>
			var testValue = 'test string';
			bean.setTestCase( testValue );
			assertEqualsString( testValue, bean.getTestCase(),
				"Not equal. Returned '#bean.getTestCase()#'. Expected 'test string'." );
		</cfscript>
	</cffunction>

	<cffunction name="testTestCaseExtends" access="public" output="false" returntype="void">
		<cfscript>
			var testValue = 'test string';
			bean.setTestCaseExtends( testValue );
			assertEqualsString( testValue, bean.getTestCaseExtends(),
				"Not equal. Returned '#bean.getTestCaseExtends()#'. Expected 'test string'." );
		</cfscript>
	</cffunction>

</cfcomponent>
