#   Copyright (c) 2004-2006 Open Source Applications Foundation
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

"""
Test parcel to fish out bug collection watching and commits

"""


from application import schema
from osaf.pim.mail import MailMessageMixin
from osaf.pim.collections import ContentCollection


class Watcher(schema.Item):

    subscribesTo = schema.One(ContentCollection, otherName = "subscribers")

    def __init__(self, *args, **kw):
        super(Watcher, self).__init__(*args, **kw)

        # The problem occurs with either this option

        #####

        #self.watchKind(MailMessageMixin.getKind(self.itsView),
        #               "mailMessageCallback")
        
        #####


        # or this one

        #####

        mailCollection = schema.ns('osaf.pim',self.itsView).mailCollection
        mailCollection.notificationQueueSubscribe(self)

        #####

    def onCollectionNotification(self, op, collection, attribute, other):
        print
        print "collection notification"
        print op
        print self.itsView
        print self.itsView.itsUUID
        self.itsView.commit()
        

    def mailMessageCallback(self, op, kind, item):
        print
        print "mailMessageCallback"
        print op
        print self.itsView
        print self.itsView.itsUUID
        self.itsView.commit()
        
def installParcel(parcel, useVersion=None):

    Watcher.update(parcel, "TheWatcher")







