/* GNUProvider.java -- providing charset class.
   Copyright (C) 2001 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
 
GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public License. */


package gnu.java.nio.charset;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Map;
import java.util.HashMap;


/**
  * This class treat charset.
  * @version 0.0
  *
  * @author Takashi Okamoto <tora@debian.org>
  */
public class GNUProvider extends CharsetProvider {
  static Map alias = new HashMap();
  
  static {
    /* set default alias */
    alias.put("UTF8","UTF_8");
    alias.put("8859_1","ISO_8859_1");
  }

  /**
   * add charsets.
   * @param m charsets which you want to add.
   */
  public final void putCharsets(Map m) {
    alias.putAll(m);
  }

  /**
   * lookup charset class from charset name.
   * @param s charset name
   * @return instance of specified charset
   */
  public final Charset charsetForName(String s) {
    /**
     * character encoding name should be upper case and use under 
     * bar '_' instead of minus '-'.
     */
    s = s.toUpperCase();
    s = s.replace('-','_');
    String csName = (String)alias.get(s);
    if(csName == null) csName = s;

    try {
      Class csclass = Class.forName("gnu.java.nio.charset." + csName);
      Charset charset = (Charset)csclass.newInstance();
      // cache should be implemented.
      return charset;
    } catch(Exception e) {
      return null;
    }
  }
}
