/* Decoder8859_1.java -- Decoder for ISO-Latin-1 Character set
   Copyright (C) 1998 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
 
GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public License. */


package gnu.java.nio.charset.decoder;

import java.io.InputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.BufferUnderflowException;
import java.nio.charset.CharacterCodingException;

/**
  * This class decodes bytes in ISO-8859-1 (Latin-1) format to Unicode.
  *
  * @version 0.0
  *
  * @author Takashi Okamoto (tora@debian.org)
  */
public class Decoder8859_1 extends CharsetDecoder
{
public Decoder8859_1(){
  super(1.0F, 2.0F);
}

//public Decoder8859_1(){}
/*************************************************************************/

public void decodeStep(ByteBuffer in, CharBuffer out) 
  throws CharacterCodingException {
  try {
    byte val = in.get();
    out.put((char)((val>=0)?val:0x100+val));
  } catch (BufferUnderflowException e){
    throw new CharacterCodingException("Pre-mature end of input"); 
  }
}

} // class Decoder8859_1





