/* Encoder8859_1.java -- Encoder for ISO-Latin-1 Character set
   Copyright (C) 1998 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
 
GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public License. */


package gnu.java.nio.charset.encoder;

import java.io.OutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CharacterCodingException;

/**
  * This class encode Unicode chars in ISO-8859-1 (Latin-1) format.
  *
  * @version 0.0
  *
  * @author Takashi Okamoto (tora@debian.org)
  */
public class Encoder8859_1 extends CharsetEncoder
{
/*************************************************************************/

public Encoder8859_1(){
  super(2.0F, 1.0F);
}

/**
  * This method converts a char array to bytes
  */
public final void encodeStep(CharBuffer in, ByteBuffer out)
  throws CharacterCodingException  {
  
  int val = in.get();
  if ((val & 0xff00)!=0){
    out.put((byte)((val >> 8)&0xff));
    out.put((byte)(val & 0xFF));   
  } else {
    out.put((byte)(val & 0xFF));   
  }	
}
} // class Encoder8859_1


