/* EncoderUTF8.java -- Encoding class for the UTF-8 scheme
   Copyright (C) 1998 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
 
GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public License. */


package gnu.java.nio.charset.encoder;

import java.io.OutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CharacterCodingException;

/**
  * This class implements an encoder for the UCS Transformation Format 8
  * (UTF-8) encoding scheme.  This is defined in RFC-2279.  We only handle
  * the 1-3 byte encodings for characters in the Unicode set.
  *
  * @version 0.0
  *
  * @author Aaron M. Renn (arenn@urbanophile.com)
  */
public class EncoderUTF8 extends CharsetEncoder
{

public EncoderUTF8(){
  super(2.0F, 1.0F);
}

/**
  * This method converts a char to bytes
  */
public final void encodeStep(CharBuffer in, ByteBuffer out)
  throws CharacterCodingException  {
  
  int val = in.get();
  if (val >= 0x0000 && val <= 0x007F)
    {
      out.put((byte)(val & 0xFF));
    }
  else if (val <= 0x07FF)
    {
      out.put((byte)(0xC0 | ((val >> 6) & 0x3F)));
      out.put((byte)(0x80 | (val & 0x3F)));
    }
  else 
    {
      out.put((byte)(0xE0 | ((val >> 12) & 0x0F)));
      out.put((byte)(0x80 | ((val >> 6) & 0x3F)));
      out.put((byte)(0x80 | (val & 0x3F)));
    }
}
} // class EncoderUTF8


