/* Charset.java -- abstract class for character set.
   Copyright (C) 2001 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
 
GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public License. */

package java.nio.charset;

import java.util.Locale;
import java.util.SortedMap;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.nio.charset.spi.CharsetProvider;
import gnu.java.nio.charset.GNUProvider;

/**
  * abstract class for character set 
  * @version 0.0
  *
  * @author Takashi Okamoto <tora@debian.org>
  */
public abstract class Charset implements Comparable {
    private static CharsetProvider cp = new GNUProvider();
    private static String charsetName = null;

    public Charset(){}
    public static boolean isSupported(String charsetName) {
      // implement me
      return true;
    }

    public static Charset forName(String charsetName) {
      // implement cache here.
      Charset cs = cp.charsetForName(charsetName);
      return cs;
    }

    public static SortedMap availableCharsets() {
      return null;
    }

    protected Charset(String canonicalName, String[] aliases) {
	charsetName = canonicalName;
	if(aliases != null){
		HashMap map = new HashMap();
		for(int i = 0; i < aliases.length; i++){
			map.put(aliases[i], charsetName);
		} 
		cp.putCharsets(map);
	} 	
    }

    public final String name() {
      return charsetName;
    }

    public final Set aliases() {
      // implement me
      return null;

    }

    public String displayName() {
      // What is different between name(),displayName() and toString()?
      return charsetName;
    }
    public final boolean isRegistered() {
      // implement me
      return true;
    }
    public String displayName(Locale locale) {
      // implement me
	return null;
    }

    public boolean canEncode() {
      // implement me
	return true;
    }

    public final int compareTo(Object o) {
	return (name().compareToIgnoreCase(((Charset)o).name()));
    }

    public final int hashCode() {
      // implement me
	return 0;
    }

    public final boolean equals(Object ob) {
      // implement me
	return false;
    }

    public final String toString() {
      // What is different between name(),displayName() and toString()?
      return charsetName;
    }

    public abstract boolean contains(Charset cs);

    public abstract CharsetDecoder newDecoder();

    public abstract CharsetEncoder newEncoder();
}

