/* CharsetDecoder.java -- abstract class for character decoder.
   Copyright (C) 2001 Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.
 
GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

As a special exception, if you link this library with other files to
produce an executable, this library does not by itself cause the
resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why the
executable file might be covered by the GNU General Public License. */

package java.nio.charset;

import java.nio.CharBuffer;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;

/**
  * abstract class for character decoder.
  * @version 0.0
  *
  * @author Takashi Okamoto <tora@debian.org>
  */
public abstract class CharsetDecoder {
  float ave = 0;
  float max = 0;
  float averageCharsPerByte(){return ave;}
  float maxCharsPerByte(){return max;}
 CharBuffer decode(ByteBuffer in){
   // implement me;
   return null;
 };
  public final boolean decode(ByteBuffer in, CharBuffer out, boolean endOfInput) 
    throws CharacterCodingException {
    while(true){
      if(!in.hasRemaining()){
	return true;
      }
      decodeStep(in, out);
    }
  }
  Charset detectedCharset(){return null;}
  public void flush(CharBuffer out){
    // implement me
  }
  void reset(){
    // implement me
  }
  void substitute(String newSubstitution){
    // implement me
  }
  String substitution(){
    // implement me
    return null;
  }


  abstract protected void decodeStep(ByteBuffer in, CharBuffer out) 
    throws CharacterCodingException;
  
  public CharsetDecoder(){
  }

  protected CharsetDecoder(float ave, float max){
    this.ave = ave;
    this.max = max;
  }
}

