import java.nio.charset.*;
import java.nio.charset.*;
import java.io.*;
import java.nio.*;
import java.nio.charset.spi.CharsetProvider;

public class testcharset {
  public static void main(String args[]){
    boolean err = false;
    try {
      FileInputStream reader = new FileInputStream(args[0]);
      CharsetProvider cp = new gnu.java.nio.charset.GNUProvider();
      // if you want to check sun's implementation. use following line.
      // CharsetProvider cp = new sun.nio.cs.StandardCharsets();

      Charset cs = cp.charsetForName(args[1]);
      CharsetEncoder ce = cs.newEncoder();
      CharsetDecoder cd = cs.newDecoder();

      byte[] input = new byte[256]; 
      char[] decode = new char[256]; 
      byte[] encode = new byte[256]; 
      int len;

      while((len = reader.read(input, 0 ,256))>0){
        /* decode from input byte */
 	ByteBuffer ib = ByteBuffer.wrap(input, 0 ,len);
	CharBuffer db = CharBuffer.wrap(decode);
        cd.decode(ib, db, true);
        cd.flush(db);

        /* encode from CharBuffer */
 	ByteBuffer eb = ByteBuffer.wrap(encode, 0 ,len);
	db.rewind();
        ce.encode(db, eb, true);
        ce.flush(eb);
	ib.rewind();
	eb.rewind();

        /* compare input and decoded character */
	for(int i=0;i<len;i++){
		byte org = ib.get();
		byte dist = eb.get();
                /* write error message if input and decoded character 
                   are difference.
                */
		if(org != dist){
                        err = true;
			System.out.println("Error!!:"+org+":"+dist);
		}
	}
      }
      if(err == false) {
        System.out.println("OK:file="+args[0]+", encoding="+args[1]);
      } else {
        System.out.println("NG:file="+args[0]+", encoding="+args[1]);
      }
    } catch (Exception e){
	e.printStackTrace();
    }
  }
}

