#define NUMTRIES 10000000
#include <sys/time.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdint.h>

int main(void)
{
	char buf[1024];
	int fd = open("/dev/null", O_WRONLY);
	struct timeval tv, end_tv;
	struct timezone tz;
	double alias_time, mytime;
	uint32_t i;

	gettimeofday(&tv, &tz);
	for (i = 0; i < NUMTRIES; i++)
	{
		cp_write(fd, buf, sizeof(buf));
	}
	gettimeofday(&end_tv, &tz);

	mytime = (end_tv.tv_sec - tv.tv_sec) * 1000;
	if (end_tv.tv_usec < tv.tv_usec)
		mytime -= (tv.tv_usec - end_tv.tv_usec) / 1000;
	else
		mytime += (end_tv.tv_usec - tv.tv_usec) / 1000;

	alias_time = mytime / NUMTRIES;
	printf("Elapsed (with alias): %g us / call\n", mytime * 1e3 / NUMTRIES);

	gettimeofday(&tv, &tz);
	for (i = 0; i < NUMTRIES; i++)
	{
		cp_write(fd, buf, sizeof(buf));
	}
	gettimeofday(&end_tv, &tz);

	printf("Elapsed: %g us / call\n", mytime * 1e3 / NUMTRIES);
	printf("Difference: %g us / call\n", (alias_time - mytime / NUMTRIES) * 1e3);
	
	close(fd);
}
